/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.entity.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.hswebframework.web.commons.entity.SimpleGenericEntity;
import org.hswebframework.web.entity.config.ConfigContent;
import org.hswebframework.web.entity.config.ConfigEntity;

public class SimpleConfigEntity
extends SimpleGenericEntity<String>
implements ConfigEntity {
    private String remark;
    private List<ConfigContent> content;
    @NotNull
    private Long createTime;
    private Long updateTime;
    private String classifiedId;
    @NotNull
    private String creatorId;
    private volatile Map<String, ConfigContent> cache;

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    @Override
    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public List<ConfigContent> getContent() {
        return this.content;
    }

    @Override
    public ConfigEntity addContent(String key, Object value, String comment) {
        if (this.content == null) {
            this.content = new ArrayList<ConfigContent>();
        }
        this.content.add(new ConfigContent(key, value, comment));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigContent get(String key) {
        if (this.cache == null) {
            SimpleConfigEntity simpleConfigEntity = this;
            synchronized (simpleConfigEntity) {
                if (this.cache == null) {
                    if (this.content == null || this.content.isEmpty()) {
                        return null;
                    }
                    this.cache = this.content.stream().collect(Collectors.toMap(ConfigContent::getKey, content -> content));
                }
            }
        }
        return this.cache.get(key);
    }

    @Override
    public void setContent(List<ConfigContent> content) {
        this.content = content;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @Override
    public Long getUpdateTime() {
        return this.updateTime;
    }

    @Override
    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public String getClassifiedId() {
        return this.classifiedId;
    }

    @Override
    public void setClassifiedId(String classifiedId) {
        this.classifiedId = classifiedId;
    }

    public SimpleConfigEntity clone() {
        SimpleConfigEntity cloned = new SimpleConfigEntity();
        cloned.setId(this.getId());
        cloned.setCreatorId(this.getCreatorId());
        this.setCreateTime(this.getCreateTime());
        cloned.content = this.getContent().stream().map(ConfigContent::clone).collect(Collectors.toList());
        return cloned;
    }
}

