/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.PagerResult;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.CreateController;
import org.hswebframework.web.controller.QueryController;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.entity.authorization.UserEntity;
import org.hswebframework.web.entity.authorization.bind.BindRoleUserEntity;
import org.hswebframework.web.service.authorization.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${hsweb.web.mappings.user:user}"})
@Authorize(permission={"user"}, description={"\u7528\u6237\u7ba1\u7406"})
@Api(value="\u7528\u6237\u7ba1\u7406", tags={"\u6743\u9650-\u7528\u6237\u7ba1\u7406"})
public class UserController
implements QueryController<UserEntity, String, QueryParamEntity>,
CreateController<BindRoleUserEntity, String, BindRoleUserEntity> {
    @Autowired
    private UserService userService;
    @Autowired
    private AuthenticationManager authenticationManager;

    public UserService getService() {
        return this.userService;
    }

    public ResponseMessage<PagerResult<UserEntity>> list(QueryParamEntity param) {
        param.excludes(new String[]{"password", "salt"});
        return super.list((Entity)param).exclude(UserEntity.class, new String[]{"password", "salt"});
    }

    public ResponseMessage<UserEntity> getByPrimaryKey(@PathVariable String id) {
        return super.getByPrimaryKey((Object)id).exclude(UserEntity.class, new String[]{"password", "salt"});
    }

    @Authorize(action={"update"})
    @PutMapping(path={"/{id:.+}"})
    @ApiOperation(value="\u6839\u636eID\u4fee\u6539\u7528\u6237\u4fe1\u606f")
    public ResponseMessage<Void> updateByPrimaryKey(@PathVariable String id, @RequestBody BindRoleUserEntity userModel) {
        this.getService().update(id, (UserEntity)userModel);
        return ResponseMessage.ok();
    }

    @Authorize(action={"get"})
    @GetMapping(path={"/{id:.+}/authentication"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u6743\u9650\u4fe1\u606f")
    public ResponseMessage<Authentication> getUserAuthentication(@PathVariable String id) {
        return ResponseMessage.ok((Object)this.authenticationManager.getByUserId(id));
    }

    @Authorize(merge=false)
    @PutMapping(path={"/password"})
    @ApiOperation(value="\u4fee\u6539\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u5bc6\u7801")
    public ResponseMessage<Void> updateLoginUserPassword(@RequestParam String password, @RequestParam String oldPassword) {
        Authentication authentication = (Authentication)Authentication.current().orElseThrow(UnAuthorizedException::new);
        this.getService().updatePassword(authentication.getUser().getId(), oldPassword, password);
        return ResponseMessage.ok();
    }

    @Authorize(action={"update"})
    @PutMapping(path={"/password/{id:.+}"})
    @ApiOperation(value="\u4fee\u6539\u6307\u5b9a\u7528\u6237\u7684\u5bc6\u7801")
    public ResponseMessage<Void> updateByPasswordPrimaryKey(@PathVariable String id, @RequestParam String password, @RequestParam String oldPassword) {
        this.getService().updatePassword(id, oldPassword, password);
        return ResponseMessage.ok();
    }

    public ResponseMessage<String> add(@RequestBody BindRoleUserEntity data) {
        Authentication authentication = Authentication.current().orElse(null);
        if (null != authentication) {
            data.setCreatorId(authentication.getUser().getId());
        }
        return super.add((Object)data);
    }

    @Authorize(action={"enable"})
    @PutMapping(path={"/{id}/enable"})
    @ApiOperation(value="\u542f\u7528\u7528\u6237")
    public ResponseMessage<Boolean> enable(@PathVariable String id) {
        return ResponseMessage.ok((Object)this.getService().enable(id));
    }

    @Authorize(action={"disable"})
    @PutMapping(path={"/{id}/disable"})
    @ApiOperation(value="\u7981\u7528\u7528\u6237")
    public ResponseMessage<Boolean> disable(@PathVariable String id) {
        return ResponseMessage.ok((Object)this.getService().disable(id));
    }

    public BindRoleUserEntity modelToEntity(BindRoleUserEntity model, BindRoleUserEntity entity) {
        return model;
    }
}

