/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.SimpleGenericEntityController;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.entity.authorization.AuthorizationSettingEntity;
import org.hswebframework.web.service.authorization.AuthorizationSettingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${hsweb.web.mappings.autz-setting:autz-setting}"})
@Authorize(permission={"autz-setting"}, description={"\u6743\u9650\u8bbe\u7f6e"})
@Api(tags={"\u6743\u9650-\u6743\u9650\u8bbe\u7f6e"}, value="\u6743\u9650\u8bbe\u7f6e")
public class AuthorizationSettingController
implements SimpleGenericEntityController<AuthorizationSettingEntity, String, QueryParamEntity> {
    private AuthorizationSettingService authorizationSettingService;

    @Autowired
    public void setAuthorizationSettingService(AuthorizationSettingService authorizationSettingService) {
        this.authorizationSettingService = authorizationSettingService;
    }

    public AuthorizationSettingService getService() {
        return this.authorizationSettingService;
    }

    @GetMapping(value={"/{type}/{settingFor}"})
    @Authorize(action={"get"})
    @ApiOperation(value="\u6839\u636etype\u548csettingFor\u83b7\u53d6\u914d\u7f6e")
    public ResponseMessage<AuthorizationSettingEntity> select(@PathVariable String type, @PathVariable String settingFor) {
        return ResponseMessage.ok((Object)this.authorizationSettingService.select(type, settingFor));
    }

    @GetMapping(value={"/permission/{permissionId}"})
    @Authorize(action={"get"})
    @ApiOperation(value="\u6839\u636e\u6743\u9650ID\u83b7\u53d6\u5bf9\u5e94\u7684\u6743\u9650\u914d\u7f6e\u4fe1\u606f")
    public ResponseMessage<List<AuthorizationSettingEntity>> selectByPermissionId(@PathVariable String permissionId) {
        return ResponseMessage.ok((Object)this.authorizationSettingService.selectByPermissionId(permissionId));
    }

    @PutMapping(value={"/merge"})
    @Authorize(action={"update"})
    @ApiOperation(value="\u5408\u5e76\u6743\u9650\u4fe1\u606f")
    public ResponseMessage<Void> mergeSetting(@RequestBody List<AuthorizationSettingEntity> list) {
        this.authorizationSettingService.mergeSetting(list);
        return ResponseMessage.ok();
    }

    @DeleteMapping(value={"/{settingId}/{permissionId}"})
    @Authorize(action={"update"})
    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u6743\u9650\u914d\u7f6e\u8be6\u60c5")
    public ResponseMessage<Void> deleteDetail(@PathVariable String settingId, @PathVariable String permissionId) {
        this.authorizationSettingService.deleteDetail(settingId, permissionId);
        return ResponseMessage.ok();
    }
}

