/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.entity.authorization.UserSettingEntity;
import org.hswebframework.web.service.authorization.UserSettingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user-setting"})
@Authorize
@Api(value="\u7528\u6237\u914d\u7f6e\u7ba1\u7406", tags={"\u7528\u6237-\u7528\u6237\u914d\u7f6e\u7ba1\u7406"})
public class UserSettingController {
    @Autowired
    private UserSettingService userSettingService;

    @GetMapping(value={"/me/{key}/{id}"})
    @Authorize(merge=false)
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u914d\u7f6e")
    public ResponseMessage<UserSettingEntity> get(Authentication authentication, @PathVariable String key, @PathVariable String id) {
        return ResponseMessage.ok((Object)this.userSettingService.selectByUser(authentication.getUser().getId(), key, id));
    }

    @GetMapping(value={"/me/{key}"})
    @Authorize(merge=false)
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u914d\u7f6e\u5217\u8868")
    public ResponseMessage<List<UserSettingEntity>> get(Authentication authentication, @PathVariable String key) {
        return ResponseMessage.ok((Object)this.userSettingService.selectByUser(authentication.getUser().getId(), key));
    }

    @PatchMapping(value={"/me/{key}"})
    @Authorize(merge=false)
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u914d\u7f6e\u5217\u8868")
    public ResponseMessage<String> save(Authentication authentication, @PathVariable String key, @Validated @RequestBody UserSettingEntity userSettingEntity) {
        userSettingEntity.setId(null);
        userSettingEntity.setUserId(authentication.getUser().getId());
        userSettingEntity.setKey(key);
        UserSettingEntity old = this.userSettingService.selectByUser(authentication.getUser().getId(), key, userSettingEntity.getSettingId());
        if (old != null) {
            userSettingEntity.setId(old.getId());
        }
        String id = (String)this.userSettingService.saveOrUpdate((Object)userSettingEntity);
        return ResponseMessage.ok((Object)id);
    }
}

