/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.starter;

import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.utils.ClassUtils;
import org.hswebframework.web.authorization.define.AopAuthorizeDefinition;
import org.hswebframework.web.authorization.define.AuthorizeDefinition;
import org.hswebframework.web.authorization.define.AuthorizeDefinitionInitializedEvent;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.commons.entity.factory.EntityFactory;
import org.hswebframework.web.entity.authorization.ActionEntity;
import org.hswebframework.web.entity.authorization.OptionalField;
import org.hswebframework.web.entity.authorization.PermissionEntity;
import org.hswebframework.web.service.authorization.PermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ReflectionUtils;

public class AutoSyncPermission
implements ApplicationListener<AuthorizeDefinitionInitializedEvent> {
    private static final Logger log = LoggerFactory.getLogger(AutoSyncPermission.class);
    private PermissionService permissionService;
    private EntityFactory entityFactory;
    private static Map<String, String> actionDescMapping = new HashMap<String, String>();

    @Autowired
    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Autowired
    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public void onApplicationEvent(AuthorizeDefinitionInitializedEvent event) {
        List definitions = event.getAllDefinition();
        HashMap<String, List> grouping = new HashMap<String, List>();
        for (Object definition : definitions) {
            for (String permissionId2 : definition.getPermissions()) {
                grouping.computeIfAbsent(permissionId2, id -> new ArrayList()).add(definition);
            }
        }
        HashMap<String, PermissionEntity> waitToSyncPermissions = new HashMap<String, PermissionEntity>();
        for (Map.Entry entry : grouping.entrySet()) {
            String permissionId2 = (String)entry.getKey();
            List allDefinition = (List)entry.getValue();
            if (allDefinition.isEmpty()) {
                return;
            }
            AuthorizeDefinition tmp = (AuthorizeDefinition)allDefinition.get(0);
            List actionDescription = allDefinition.stream().map(AuthorizeDefinition::getActionDescription).flatMap(Stream::of).collect(Collectors.toList());
            List actions = allDefinition.stream().map(AuthorizeDefinition::getActions).flatMap(Collection::stream).collect(Collectors.toList());
            HashSet<ActionEntity> actionEntities = new HashSet<ActionEntity>(actions.size());
            if (!actions.isEmpty()) {
                for (int i = 0; i < actions.size(); ++i) {
                    String action = (String)actions.get(i);
                    String desc = actionDescription.size() > i ? (String)actionDescription.get(i) : actionDescMapping.getOrDefault(actions.get(i), action);
                    ActionEntity actionEntity = new ActionEntity();
                    actionEntity.setAction(action);
                    actionEntity.setDescribe(desc);
                    actionEntities.add(actionEntity);
                }
            }
            PermissionEntity entity = (PermissionEntity)this.entityFactory.newInstance(PermissionEntity.class);
            if (tmp instanceof AopAuthorizeDefinition) {
                AopAuthorizeDefinition aopAuthorizeDefinition = (AopAuthorizeDefinition)tmp;
                Class type = aopAuthorizeDefinition.getTargetClass();
                Class genType = this.entityFactory.getInstanceType(ClassUtils.getGenericType((Class)type));
                ArrayList<OptionalField> optionalFields = new ArrayList<OptionalField>();
                entity.setOptionalFields(optionalFields);
                if (genType != Object.class) {
                    ArrayList fields = new ArrayList();
                    ReflectionUtils.doWithFields((Class)genType, fields::add, field -> (field.getModifiers() & 8) == 0);
                    for (Field field2 : fields) {
                        if ("id".equals(field2.getName())) continue;
                        ApiModelProperty property = field2.getAnnotation(ApiModelProperty.class);
                        OptionalField optionalField = new OptionalField();
                        optionalField.setName(field2.getName());
                        if (null != property) {
                            if (property.hidden()) continue;
                            optionalField.setDescribe(property.value());
                        }
                        optionalFields.add(optionalField);
                    }
                }
            }
            entity.setId((Object)permissionId2);
            entity.setName(tmp.getPermissionDescription().length > 0 ? tmp.getPermissionDescription()[0] : permissionId2);
            entity.setActions(new ArrayList(actionEntities));
            entity.setType("default");
            entity.setStatus(DataStatus.STATUS_ENABLED);
            waitToSyncPermissions.putIfAbsent(entity.getId(), entity);
        }
        Map oldCache = this.permissionService.select().stream().collect(Collectors.toMap(PermissionEntity::getId, Function.identity()));
        waitToSyncPermissions.forEach((permissionId, permission) -> {
            log.info("try sync permission[{}].{}", permissionId, (Object)permission.getActions());
            PermissionEntity oldPermission = (PermissionEntity)oldCache.get(permissionId);
            if (oldPermission == null) {
                this.permissionService.insert(permission);
            } else {
                HashSet<ActionEntity> oldAction = new HashSet<ActionEntity>();
                if (oldPermission.getActions() != null) {
                    oldAction.addAll(oldPermission.getActions());
                }
                Map actionCache = oldAction.stream().collect(Collectors.toMap(ActionEntity::getAction, Function.identity()));
                boolean permissionChanged = false;
                for (ActionEntity actionEntity : permission.getActions()) {
                    if (actionCache.get(actionEntity.getAction()) != null) continue;
                    oldAction.add(actionEntity);
                    permissionChanged = true;
                }
                if (permissionChanged) {
                    oldPermission.setActions(new ArrayList(oldAction));
                    this.permissionService.updateByPk((Object)oldPermission.getId(), (Object)oldPermission);
                }
                actionCache.clear();
            }
        });
        oldCache.clear();
        waitToSyncPermissions.clear();
        definitions.clear();
        grouping.clear();
    }

    static {
        actionDescMapping.put("query", "\u67e5\u8be2");
        actionDescMapping.put("add", "\u65b0\u589e");
        actionDescMapping.put("get", "\u67e5\u770b\u8be6\u60c5");
        actionDescMapping.put("update", "\u4fee\u6539");
        actionDescMapping.put("delete", "\u5220\u9664");
        actionDescMapping.put("disable", "\u7981\u7528");
        actionDescMapping.put("enable", "\u542f\u7528");
        actionDescMapping.put("export", "\u5bfc\u51fa");
        actionDescMapping.put("import", "\u5bfc\u5165");
    }
}

