/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.starter;

import org.hswebframework.web.authorization.AuthenticationInitializeService;
import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.basic.embed.EmbedAuthenticationManager;
import org.hswebframework.web.authorization.setting.UserSettingManager;
import org.hswebframework.web.authorization.simple.DefaultAuthorizationAutoConfiguration;
import org.hswebframework.web.authorization.starter.AutoSyncPermission;
import org.hswebframework.web.authorization.twofactor.TwoFactorTokenManager;
import org.hswebframework.web.authorization.twofactor.defaults.HashMapTwoFactorTokenManager;
import org.hswebframework.web.service.authorization.simple.SimpleAuthenticationManager;
import org.hswebframework.web.service.authorization.simple.totp.TotpTwoFactorProvider;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ComponentScan(value={"org.hswebframework.web.service.authorization.simple", "org.hswebframework.web.authorization.controller"})
@MapperScan(value={"org.hswebframework.web.authorization.dao"})
@AutoConfigureBefore(value={DefaultAuthorizationAutoConfiguration.class}, name={"org.hswebframework.web.authorization.basic.configuration.AuthorizingHandlerAutoConfiguration"})
public class AuthorizationAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="hsweb.authorize", name={"sync"}, havingValue="true")
    public AutoSyncPermission autoSyncPermission() {
        return new AutoSyncPermission();
    }

    @Bean
    @ConditionalOnMissingBean(value={TwoFactorTokenManager.class})
    public TwoFactorTokenManager twoFactorTokenManager() {
        return new HashMapTwoFactorTokenManager();
    }

    @Bean
    @ConditionalOnProperty(prefix="hsweb.authorize.two-factor.totp", name={"enable"}, havingValue="true")
    @ConfigurationProperties(prefix="hsweb.authorize.two-factor.totp")
    public TotpTwoFactorProvider totpTwoFactorProvider(UserSettingManager userSettingManager, TwoFactorTokenManager twoFactorTokenManager) {
        return new TotpTwoFactorProvider(userSettingManager, twoFactorTokenManager);
    }

    @ConditionalOnClass(value={EmbedAuthenticationManager.class})
    @Configuration
    public static class EmbedAuthenticationManagerAutoConfiguration {
        @Bean
        public EmbedAuthenticationManager embedAuthenticationManager() {
            return new EmbedAuthenticationManager();
        }

        @Bean
        @Primary
        public AuthenticationManager authenticationManager(EmbedAuthenticationManager embedAuthenticationManager, AuthenticationInitializeService authenticationInitializeService) {
            return new SimpleAuthenticationManager(authenticationInitializeService, (AuthenticationManager)embedAuthenticationManager);
        }
    }

    @ConditionalOnMissingClass(value={"org.hswebframework.web.authorization.basic.embed.EmbedAuthenticationManager"})
    @Configuration
    public static class NoEmbedAuthenticationManagerAutoConfiguration {
        @Bean
        @Primary
        public AuthenticationManager authenticationManager(AuthenticationInitializeService authenticationInitializeService) {
            return new SimpleAuthenticationManager(authenticationInitializeService);
        }
    }
}

