/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.starter;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.hswebframework.web.authorization.basic.web.AuthorizedToken;
import org.hswebframework.web.authorization.basic.web.ParsedToken;
import org.hswebframework.web.authorization.basic.web.UserTokenForTypeParser;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.entity.authorization.UserEntity;
import org.hswebframework.web.service.authorization.UserService;

public class BasicAuthorizationTokenParser
implements UserTokenForTypeParser {
    private UserService userService;
    private UserTokenManager userTokenManager;

    public String getTokenType() {
        return "basic";
    }

    public BasicAuthorizationTokenParser(UserService userService, UserTokenManager userTokenManager) {
        this.userService = userService;
        this.userTokenManager = userTokenManager;
    }

    public ParsedToken parseToken(HttpServletRequest request) {
        String[] info;
        String authorization = request.getHeader("Authorization");
        if (authorization == null) {
            return null;
        }
        if (authorization.contains(" ") && (info = authorization.split("[ ]"))[0].equalsIgnoreCase(this.getTokenType())) {
            authorization = info[1];
        }
        try {
            String[] arr;
            UserEntity user;
            final String usernameAndPassword = new String(Base64.decodeBase64((String)authorization));
            UserToken token = this.userTokenManager.getByToken(usernameAndPassword);
            if (token != null && token.isNormal()) {
                return new ParsedToken(){

                    public String getToken() {
                        return usernameAndPassword;
                    }

                    public String getType() {
                        return BasicAuthorizationTokenParser.this.getTokenType();
                    }
                };
            }
            if (usernameAndPassword.contains(":") && (user = this.userService.selectByUserNameAndPassword((arr = usernameAndPassword.split("[:]"))[0], arr[1])) != null) {
                return new AuthorizedToken(){

                    public String getUserId() {
                        return (String)user.getId();
                    }

                    public String getToken() {
                        return usernameAndPassword;
                    }

                    public String getType() {
                        return BasicAuthorizationTokenParser.this.getTokenType();
                    }

                    public long getMaxInactiveInterval() {
                        return 3600000L;
                    }
                };
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }
}

