/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.starter;

import org.hswebframework.web.authorization.AuthenticationInitializeService;
import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.simple.DefaultAuthorizationAutoConfiguration;
import org.hswebframework.web.authorization.starter.AutoSyncPermission;
import org.hswebframework.web.authorization.starter.BasicAuthorizationConfiguration;
import org.hswebframework.web.service.authorization.simple.SimpleAuthenticationManager;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ComponentScan(value={"org.hswebframework.web.service.authorization.simple", "org.hswebframework.web.authorization.controller"})
@MapperScan(value={"org.hswebframework.web.authorization.dao"})
@AutoConfigureBefore(value={DefaultAuthorizationAutoConfiguration.class}, name={"org.hswebframework.web.authorization.basic.configuration.AuthorizingHandlerAutoConfiguration"})
@Import(value={BasicAuthorizationConfiguration.class})
public class AuthorizationAutoConfiguration {
    @Bean
    public AuthenticationManager authenticationManager(AuthenticationInitializeService authenticationInitializeService) {
        return new SimpleAuthenticationManager(authenticationInitializeService);
    }

    @Bean
    @ConditionalOnProperty(prefix="hsweb.authorize", name={"sync"}, havingValue="true")
    public AutoSyncPermission autoSyncPermission() {
        return new AutoSyncPermission();
    }
}

