/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.authorization.simple.totp;

import org.hswebframework.web.authorization.setting.UserSettingManager;
import org.hswebframework.web.authorization.setting.UserSettingPermission;
import org.hswebframework.web.authorization.twofactor.TwoFactorTokenManager;
import org.hswebframework.web.authorization.twofactor.defaults.DefaultTwoFactorValidatorProvider;
import org.hswebframework.web.entity.authorization.UserEntity;
import org.hswebframework.web.service.authorization.events.TotpTwoFactorCreatedEvent;
import org.hswebframework.web.service.authorization.events.UserCreatedEvent;
import org.hswebframework.web.service.authorization.simple.totp.TotpUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
public class TotpTwoFactorProvider
extends DefaultTwoFactorValidatorProvider {
    private UserSettingManager userSettingManager;
    private String domain = "hsweb.me";
    private String settingId = "tow-factor-totp-key";
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public TotpTwoFactorProvider(UserSettingManager userSettingManager, TwoFactorTokenManager twoFactorTokenManager) {
        super("totp", twoFactorTokenManager);
        this.userSettingManager = userSettingManager;
    }

    @EventListener
    public void handleUserCreatedEvent(UserCreatedEvent event) {
        String key = TotpUtil.getRandomSecretBase32(64);
        UserEntity userEntity = event.getUserEntity();
        String keyUrl = TotpUtil.generateTotpString(userEntity.getUsername(), this.domain, key);
        this.userSettingManager.saveSetting((String)userEntity.getId(), this.settingId, key, UserSettingPermission.NONE);
        this.eventPublisher.publishEvent((Object)new TotpTwoFactorCreatedEvent(userEntity, keyUrl));
    }

    protected boolean validate(String userId, String code) {
        return this.userSettingManager.getSetting(userId, this.settingId).asString().map(key -> TotpUtil.verify(key, code)).orElse(false);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getSettingId() {
        return this.settingId;
    }

    public void setSettingId(String settingId) {
        this.settingId = settingId;
    }
}

