/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.authorization.simple.totp;

public class HexEncoding {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    private HexEncoding() {
    }

    public static String encode(byte[] data) {
        StringBuilder result = new StringBuilder(data.length * 2);
        for (byte b : data) {
            result.append(HEX_DIGITS[b >>> 4 & 0xF]);
            result.append(HEX_DIGITS[b & 0xF]);
        }
        return result.toString();
    }

    public static byte[] decode(String encoded) {
        int resultLengthBytes = (encoded.length() + 1) / 2;
        byte[] result = new byte[resultLengthBytes];
        int resultOffset = 0;
        int encodedCharOffset = 0;
        if (encoded.length() % 2 != 0) {
            result[resultOffset++] = (byte)HexEncoding.getHexadecimalDigitValue(encoded.charAt(encodedCharOffset));
            ++encodedCharOffset;
        }
        int len = encoded.length();
        while (encodedCharOffset < len) {
            result[resultOffset++] = (byte)(HexEncoding.getHexadecimalDigitValue(encoded.charAt(encodedCharOffset)) << 4 | HexEncoding.getHexadecimalDigitValue(encoded.charAt(encodedCharOffset + 1)));
            encodedCharOffset += 2;
        }
        return result;
    }

    private static int getHexadecimalDigitValue(char c) {
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new IllegalArgumentException("Invalid hexadecimal digit at position : '" + c + "' (0x" + Integer.toHexString(c) + ")");
    }
}

