/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.authorization.simple;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.commons.entity.TreeSortSupportEntity;
import org.hswebframework.web.commons.entity.TreeSupportEntity;
import org.hswebframework.web.dao.authorization.MenuGroupDao;
import org.hswebframework.web.dao.dynamic.UpdateByEntityDao;
import org.hswebframework.web.entity.authorization.MenuEntity;
import org.hswebframework.web.entity.authorization.MenuGroupBindEntity;
import org.hswebframework.web.entity.authorization.MenuGroupEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.AbstractTreeSortService;
import org.hswebframework.web.service.DefaultDSLUpdateService;
import org.hswebframework.web.service.authorization.MenuGroupBindService;
import org.hswebframework.web.service.authorization.MenuGroupService;
import org.hswebframework.web.service.authorization.MenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="menuGroupService")
@CacheConfig(cacheNames={"hsweb-menu-"})
public class SimpleMenuGroupService
extends AbstractTreeSortService<MenuGroupEntity, String>
implements MenuGroupService {
    @Autowired
    private MenuGroupDao menuGroupDao;
    @Autowired
    private MenuService menuService;
    @Autowired
    private MenuGroupBindService menuGroupBindService;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public MenuGroupDao getDao() {
        return this.menuGroupDao;
    }

    @Cacheable(key="'group-id-list:'+(#groupId==null?0:#groupId.hashCode())")
    public List<MenuEntity> getMenuByGroupId(List<String> groupId) {
        List bindEntities = this.menuGroupBindService.selectByPk(groupId);
        if (bindEntities == null || bindEntities.isEmpty()) {
            return new LinkedList<MenuEntity>();
        }
        return this.menuService.selectByPk(bindEntities.stream().map(MenuGroupBindEntity::getMenuId).distinct().collect(Collectors.toList()));
    }

    @CacheEvict(allEntries=true)
    public String insert(MenuGroupEntity entity) {
        entity.setStatus(Byte.valueOf((byte)1));
        String id = (String)super.insert((TreeSortSupportEntity)entity);
        List bindEntities = entity.getBindInfo();
        if (bindEntities != null && !bindEntities.isEmpty()) {
            TreeSupportEntity.forEach((Collection)bindEntities, bindEntity -> {
                bindEntity.setGroupId(id);
                entity.setStatus(Byte.valueOf((byte)1));
            });
            this.menuGroupBindService.insertBatch((Collection)bindEntities);
        }
        return id;
    }

    @CacheEvict(allEntries=true)
    public int updateByPk(MenuGroupEntity entity) {
        int size = super.updateByPk((TreeSortSupportEntity)entity);
        List bindEntities = entity.getBindInfo();
        if (bindEntities != null && !bindEntities.isEmpty()) {
            TreeSupportEntity.forEach((Collection)bindEntities, bindEntity -> bindEntity.setGroupId((String)entity.getId()));
            this.menuGroupBindService.deleteByGroupId((String)entity.getId());
            this.menuGroupBindService.insertBatch((Collection)bindEntities);
        }
        return size;
    }

    @CacheEvict(allEntries=true)
    public int updateByPk(List<MenuGroupEntity> data) {
        return super.updateByPk(data);
    }

    @CacheEvict(allEntries=true)
    public int updateByPk(String id, MenuGroupEntity entity) {
        return super.updateByPk((Object)id, (GenericEntity)entity);
    }

    @CacheEvict(allEntries=true)
    public MenuGroupEntity deleteByPk(String id) {
        return (MenuGroupEntity)super.deleteByPk((Object)id);
    }

    @CacheEvict(allEntries=true)
    public void enable(String id) {
        this.tryValidateProperty(StringUtils.hasLength((String)id), "id", "{id_is_null}");
        ((Update)this.createUpdate().set("status", (Object)1).where("id", (Object)id)).exec();
    }

    @CacheEvict(allEntries=true)
    public void disable(String id) {
        this.tryValidateProperty(StringUtils.hasLength((String)id), "id", "{id_is_null}");
        ((Update)DefaultDSLUpdateService.createUpdate((UpdateByEntityDao)this.getDao()).set("status", (Object)0).where("id", (Object)id)).exec();
    }
}

