/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.authorization.simple.totp;

import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.hswebframework.web.service.authorization.simple.totp.Base32String;
import org.hswebframework.web.service.authorization.simple.totp.HexEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TotpUtil.class);
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};

    private TotpUtil() {
    }

    private static byte[] hmac_sha(String crypto, byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    private static byte[] hexStr2Bytes(String hex) {
        byte[] bArray = new BigInteger("10" + hex, 16).toByteArray();
        byte[] ret = new byte[bArray.length - 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = bArray[i + 1];
        }
        return ret;
    }

    public static String generateTOTP(String key, String time, String returnDigits) {
        return TotpUtil.generateTOTP(key, time, returnDigits, "HmacSHA1");
    }

    public static String generateTOTP256(String key, String time, String returnDigits) {
        return TotpUtil.generateTOTP(key, time, returnDigits, "HmacSHA256");
    }

    public static String generateTOTP512(String key, String time, String returnDigits) {
        return TotpUtil.generateTOTP(key, time, returnDigits, "HmacSHA512");
    }

    public static String generateTOTP(String key, String time, String returnDigits, String crypto) {
        int codeDigits = Integer.decode(returnDigits);
        StringBuilder timeBuilder = new StringBuilder(time);
        while (timeBuilder.length() < 16) {
            timeBuilder.insert(0, "0");
        }
        time = timeBuilder.toString();
        byte[] msg = TotpUtil.hexStr2Bytes(time);
        byte[] k = TotpUtil.hexStr2Bytes(key);
        byte[] hash = TotpUtil.hmac_sha(crypto, k, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % DIGITS_POWER[codeDigits];
        StringBuilder result = new StringBuilder(Integer.toString(otp));
        while (result.length() < codeDigits) {
            result.insert(0, "0");
        }
        return result.toString();
    }

    public static boolean verify(String secretBase32, String code) {
        return TotpUtil.generate(secretBase32).equals(code);
    }

    public static String generateTotpString(String accoName, String domain, String secretBase32) {
        return "otpauth://totp/" + accoName + "@" + domain + "?secret=" + secretBase32;
    }

    public static String generate(String secretBase32) {
        String secretHex;
        try {
            secretHex = HexEncoding.encode(Base32String.decode(secretBase32));
        }
        catch (Base32String.DecodingException e) {
            LOGGER.error("\u89e3\u7801" + secretBase32 + "\u51fa\u9519\uff0c", (Throwable)e);
            throw new RuntimeException("\u89e3\u7801Base32\u51fa\u9519");
        }
        long X = 30L;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        long currentTime = System.currentTimeMillis() / 1000L;
        try {
            long t = currentTime / X;
            StringBuilder steps = new StringBuilder(Long.toHexString(t).toUpperCase());
            while (steps.length() < 16) {
                steps.insert(0, "0");
            }
            return TotpUtil.generateTOTP(secretHex, steps.toString(), "6", "HmacSHA1");
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u52a8\u6001\u53e3\u4ee4\u51fa\u9519\uff1a" + secretBase32, (Throwable)e);
            throw new RuntimeException("\u751f\u6210\u52a8\u6001\u53e3\u4ee4\u51fa\u9519");
        }
    }

    public static String getRandomSecretBase32(int length) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[length / 2];
        random.nextBytes(salt);
        return Base32String.encode(salt);
    }
}

