/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.authorization.simple;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.dao.authorization.UserSettingDao;
import org.hswebframework.web.entity.authorization.UserSettingEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.EnableCacheGenericEntityService;
import org.hswebframework.web.service.authorization.UserSettingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"user-setting"})
public class SimpleUserSettingService
extends EnableCacheGenericEntityService<UserSettingEntity, String>
implements UserSettingService {
    @Autowired
    private UserSettingDao userSettingDao;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public UserSettingDao getDao() {
        return this.userSettingDao;
    }

    @Cacheable(key="'user:'+#userId+'.'+#key")
    public List<UserSettingEntity> selectByUser(String userId, String key) {
        Objects.requireNonNull(userId);
        Objects.requireNonNull(key);
        return ((Query)((Query)this.createQuery().where("userId", (Object)userId)).and("key", (Object)key)).listNoPaging();
    }

    @Cacheable(key="'user:'+#userId+'.'+#key+'.'+#settingId")
    public UserSettingEntity selectByUser(String userId, String key, String settingId) {
        Objects.requireNonNull(userId);
        Objects.requireNonNull(key);
        Objects.requireNonNull(settingId);
        return (UserSettingEntity)((Query)((Query)((Query)this.createQuery().where("userId", (Object)userId)).and("key", (Object)key)).and("settingId", (Object)settingId)).single();
    }

    @Caching(evict={@CacheEvict(key="'user:'+#entity.userId+'.'+#entity.key+'.'+#entity.settingId"), @CacheEvict(key="'user:'+#entity.userId+'.'+#entity.key")})
    public String insert(UserSettingEntity entity) {
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        return (String)super.insert((GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'user:'+#entity.userId+'.'+#entity.key+'.'+#entity.settingId"), @CacheEvict(key="'user:'+#entity.userId+'.'+#entity.key")})
    public String saveOrUpdate(UserSettingEntity entity) {
        return (String)super.saveOrUpdate((GenericEntity)entity);
    }

    @Caching(evict={@CacheEvict(key="'user:'+#entity.userId+'.'+#entity.key+'.'+#entity.settingId"), @CacheEvict(key="'user:'+#entity.userId+'.'+#entity.key")})
    public int updateByPk(String id, UserSettingEntity entity) {
        entity.setUpdateTime(new Date());
        return super.updateByPk((Object)id, (GenericEntity)entity);
    }
}

