/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.authorization.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.dsl.Delete;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationInitializeService;
import org.hswebframework.web.authorization.Permission;
import org.hswebframework.web.authorization.User;
import org.hswebframework.web.authorization.simple.SimpleAuthentication;
import org.hswebframework.web.authorization.simple.SimplePermission;
import org.hswebframework.web.authorization.simple.SimpleRole;
import org.hswebframework.web.authorization.simple.SimpleUser;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.commons.entity.TreeSupportEntity;
import org.hswebframework.web.dao.authorization.AuthorizationSettingDao;
import org.hswebframework.web.dao.authorization.AuthorizationSettingDetailDao;
import org.hswebframework.web.dao.dynamic.DeleteByEntityDao;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.entity.authorization.ActionEntity;
import org.hswebframework.web.entity.authorization.AuthorizationSettingDetailEntity;
import org.hswebframework.web.entity.authorization.AuthorizationSettingEntity;
import org.hswebframework.web.entity.authorization.AuthorizationSettingMenuEntity;
import org.hswebframework.web.entity.authorization.MenuEntity;
import org.hswebframework.web.entity.authorization.ParentPermission;
import org.hswebframework.web.entity.authorization.PermissionEntity;
import org.hswebframework.web.entity.authorization.UserEntity;
import org.hswebframework.web.entity.authorization.UserMenuEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.DefaultDSLDeleteService;
import org.hswebframework.web.service.DefaultDSLQueryService;
import org.hswebframework.web.service.GenericEntityService;
import org.hswebframework.web.service.authorization.AuthorizationSettingMenuService;
import org.hswebframework.web.service.authorization.AuthorizationSettingService;
import org.hswebframework.web.service.authorization.AuthorizationSettingTypeSupplier;
import org.hswebframework.web.service.authorization.DataAccessFactory;
import org.hswebframework.web.service.authorization.MenuService;
import org.hswebframework.web.service.authorization.PermissionService;
import org.hswebframework.web.service.authorization.UserMenuManagerService;
import org.hswebframework.web.service.authorization.UserService;
import org.hswebframework.web.service.authorization.events.ClearUserAuthorizationCacheEvent;
import org.hswebframework.web.validator.group.CreateGroup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="authorizationSettingService")
public class SimpleAuthorizationSettingService
extends GenericEntityService<AuthorizationSettingEntity, String>
implements AuthorizationSettingService,
AuthenticationInitializeService,
UserMenuManagerService {
    private AuthorizationSettingDao authorizationSettingDao;
    private AuthorizationSettingDetailDao authorizationSettingDetailDao;
    private AuthorizationSettingMenuService authorizationSettingMenuService;
    private MenuService menuService;
    private UserService userService;
    private PermissionService permissionService;
    private List<AuthorizationSettingTypeSupplier> authorizationSettingTypeSuppliers;
    private DataAccessFactory dataAccessFactory;

    protected IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public AuthorizationSettingDao getDao() {
        return this.authorizationSettingDao;
    }

    public AuthorizationSettingEntity select(String type, String settingFor) {
        this.tryValidateProperty(type != null, "type", "{can not be null}");
        this.tryValidateProperty(settingFor != null, "settingFor", "{can not be null}");
        return (AuthorizationSettingEntity)((Query)((Query)this.createQuery().where("type", (Object)type)).and("settingFor", (Object)settingFor)).single();
    }

    @CacheEvict(cacheNames={"user-auth-", "hsweb-user-menu-"}, allEntries=true)
    public String saveOrUpdate(AuthorizationSettingEntity entity) {
        AuthorizationSettingEntity old = this.select(entity.getType(), entity.getSettingFor());
        if (old != null) {
            this.updateByPk((String)old.getId(), entity);
            return (String)old.getId();
        }
        return this.insert(entity);
    }

    @CacheEvict(cacheNames={"user-auth-", "hsweb-user-menu-"}, allEntries=true)
    public String insert(AuthorizationSettingEntity entity) {
        this.tryValidateProperty(this.select(entity.getType(), entity.getSettingFor()) == null, "settingFor", "\u5b58\u5728\u76f8\u540c\u7684\u914d\u7f6e!");
        entity.setStatus(DataStatus.STATUS_ENABLED);
        String id = (String)super.insert((GenericEntity)entity);
        if (entity.getMenus() != null) {
            TreeSupportEntity.forEach((Collection)entity.getMenus(), menu -> {
                menu.setStatus(DataStatus.STATUS_ENABLED);
                menu.setSettingId(id);
            });
            this.authorizationSettingMenuService.insertBatch((Collection)entity.getMenus());
        }
        if (entity.getDetails() != null) {
            for (AuthorizationSettingDetailEntity detail : entity.getDetails()) {
                detail.setId(this.getIDGenerator().generate());
                detail.setSettingId(id);
                detail.setStatus(DataStatus.STATUS_ENABLED);
                this.tryValidate(detail, new Class[]{CreateGroup.class});
                this.authorizationSettingDetailDao.insert(detail);
            }
        }
        return id;
    }

    @CacheEvict(cacheNames={"user-auth-", "hsweb-user-menu-"}, allEntries=true)
    public int updateByPk(String id, AuthorizationSettingEntity entity) {
        int size = super.updateByPk((Object)id, (GenericEntity)entity);
        if (entity.getMenus() != null) {
            this.authorizationSettingMenuService.deleteBySettingId(id);
            TreeSupportEntity.forEach((Collection)entity.getMenus(), menu -> {
                menu.setStatus(DataStatus.STATUS_ENABLED);
                menu.setSettingId(id);
            });
            this.authorizationSettingMenuService.insertBatch((Collection)entity.getMenus());
        }
        if (entity.getDetails() != null) {
            ((Delete)DefaultDSLDeleteService.createDelete((DeleteByEntityDao)this.authorizationSettingDetailDao).where("settingId", (Object)id)).exec();
            for (AuthorizationSettingDetailEntity detail : entity.getDetails()) {
                detail.setId(this.getIDGenerator().generate());
                detail.setSettingId(id);
                detail.setStatus(DataStatus.STATUS_ENABLED);
                this.tryValidate(detail, new Class[]{CreateGroup.class});
                this.authorizationSettingDetailDao.insert(detail);
            }
        }
        return size;
    }

    @CacheEvict(cacheNames={"user-auth-", "hsweb-user-menu-"}, allEntries=true)
    public AuthorizationSettingEntity deleteByPk(String id) {
        Objects.requireNonNull(id, "id can not be null");
        this.authorizationSettingMenuService.deleteBySettingId(id);
        ((Delete)DefaultDSLDeleteService.createDelete((DeleteByEntityDao)this.authorizationSettingDetailDao).where("settingId", (Object)id)).exec();
        return (AuthorizationSettingEntity)super.deleteByPk((Object)id);
    }

    private List<AuthorizationSettingEntity> getUserSetting(String userId) {
        Map<String, List<AuthorizationSettingTypeSupplier.SettingInfo>> settingInfo = this.authorizationSettingTypeSuppliers.stream().map(supplier -> supplier.get(userId)).flatMap(Collection::stream).collect(Collectors.groupingBy(AuthorizationSettingTypeSupplier.SettingInfo::getType));
        Stream settingInfoStream = settingInfo.entrySet().stream();
        if (settingInfo.size() > 1) {
            settingInfoStream = (Stream)settingInfoStream.parallel();
        }
        return settingInfoStream.map(entry -> ((Query)((Query)this.createQuery().where("type", entry.getKey())).and().in("settingFor", (Collection)((List)entry.getValue()).stream().map(AuthorizationSettingTypeSupplier.SettingInfo::getSettingFor).collect(Collectors.toList()))).listNoPaging()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Cacheable(cacheNames={"hsweb-user-menu-"}, key="'user-menu-list:'+#userId")
    public List<UserMenuEntity> getUserMenuAsList(String userId) {
        if (null == userId) {
            return new ArrayList<UserMenuEntity>();
        }
        UserEntity userEntity = (UserEntity)this.userService.selectByPk((Object)userId);
        if (userEntity == null) {
            return new ArrayList<UserMenuEntity>();
        }
        List<AuthorizationSettingEntity> entities = this.getUserSetting(userId);
        if (entities.isEmpty()) {
            return new ArrayList<UserMenuEntity>();
        }
        List settingIdList = entities.stream().map(GenericEntity::getId).collect(Collectors.toList());
        List menuEntities = this.authorizationSettingMenuService.selectBySettingId(settingIdList);
        List menuIdList = menuEntities.stream().map(AuthorizationSettingMenuEntity::getMenuId).distinct().collect(Collectors.toList());
        if (menuIdList.isEmpty()) {
            return new ArrayList<UserMenuEntity>();
        }
        Map menuCache = this.menuService.selectByPk(menuIdList).stream().collect(Collectors.toMap(GenericEntity::getId, Function.identity()));
        LinkedList<UserMenuEntity> reBuildMenu = new LinkedList<UserMenuEntity>();
        for (MenuEntity menuEntity : menuCache.values()) {
            UserMenuEntity menu = (UserMenuEntity)this.entityFactory.newInstance(UserMenuEntity.class, (Object)menuEntity);
            menu.setSortIndex(menuEntity.getSortIndex());
            menu.setLevel(menuEntity.getLevel());
            menu.setId(menuEntity.getId());
            menu.setParentId(menuEntity.getParentId());
            menu.setMenuId((String)menuEntity.getId());
            reBuildMenu.add(menu);
        }
        Collections.sort(reBuildMenu);
        return reBuildMenu;
    }

    @Cacheable(cacheNames={"hsweb-user-menu-"}, key="'menu-tree:'+#userId")
    public List<UserMenuEntity> getUserMenuAsTree(String userId) {
        return TreeSupportEntity.list2tree(this.getUserMenuAsList(userId), UserMenuEntity::setChildren, menuEntity -> StringUtils.isEmpty((Object)menuEntity.getParentId()) || "-1".equals(menuEntity.getParentId()));
    }

    @TransactionalEventListener(condition="#event.all")
    @Caching(evict={@CacheEvict(cacheNames={"hsweb-user-menu-"}, allEntries=true), @CacheEvict(cacheNames={"user-auth-"}, allEntries=true)})
    public void clearAllUserCache(ClearUserAuthorizationCacheEvent event) {
        this.logger.debug("clear all user authorization cache");
    }

    @TransactionalEventListener(condition="!#event.all")
    @Caching(evict={@CacheEvict(value={"user-auth-"}, key="#event.getUserId()"), @CacheEvict(value={"hsweb-user-menu-"}, key="'user-menu-list:'+#event.getUserId()"), @CacheEvict(value={"hsweb-user-menu-"}, key="'menu-tree:'+#event.getUserId()")})
    public void clearUserCache(ClearUserAuthorizationCacheEvent event) {
        this.logger.debug("clear user:{} authorization cache", (Object)event.getUserId());
    }

    public Authentication initUserAuthorization(String userId) {
        if (null == userId) {
            return null;
        }
        UserEntity userEntity = (UserEntity)this.userService.selectByPk((Object)userId);
        if (userEntity == null) {
            return null;
        }
        SimpleAuthentication authentication = new SimpleAuthentication();
        authentication.setUser((User)SimpleUser.builder().id(userId).username(userEntity.getUsername()).name(userEntity.getName()).type("default").build());
        authentication.setRoles(this.userService.getUserRole(userId).stream().map(role -> new SimpleRole((String)role.getId(), role.getName())).collect(Collectors.toList()));
        List settingIdList = this.getUserSetting(userId).stream().map(GenericEntity::getId).collect(Collectors.toList());
        if (settingIdList.isEmpty()) {
            authentication.setPermissions(new ArrayList());
            return authentication;
        }
        List detailList = ((Query)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.authorizationSettingDetailDao).where("status", (Object)AuthorizationSettingDetailEntity.STATE_OK)).and().in("settingId", settingIdList)).listNoPaging();
        authentication.setPermissions(this.initPermission(detailList));
        return authentication;
    }

    public List<Permission> initPermission(String type, String settingFor) {
        AuthorizationSettingEntity entity = this.select(type, settingFor);
        if (entity == null) {
            return new ArrayList<Permission>();
        }
        List detailList = ((Query)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.authorizationSettingDetailDao).where("status", (Object)AuthorizationSettingDetailEntity.STATE_OK)).and().is("settingId", entity.getId())).listNoPaging();
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return new ArrayList<Permission>();
        }
        return this.initPermission(detailList);
    }

    private List<Permission> initPermission(List<AuthorizationSettingDetailEntity> detailList) {
        List permissionIds = detailList.stream().map(AuthorizationSettingDetailEntity::getPermissionId).distinct().collect(Collectors.toList());
        Map permissionEntityCache = this.permissionService.selectByPk(permissionIds).stream().collect(Collectors.toMap(PermissionEntity::getId, Function.identity()));
        detailList = detailList.stream().filter(detail -> {
            PermissionEntity entity = (PermissionEntity)permissionEntityCache.get(detail.getPermissionId());
            if (entity == null || !DataStatus.STATUS_ENABLED.equals(entity.getStatus())) {
                return false;
            }
            List allActions = entity.getActions().stream().map(ActionEntity::getAction).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)entity.getActions()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)detail.getActions())) {
                detail.setActions(detail.getActions().stream().filter(allActions::contains).collect(Collectors.toSet()));
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entity.getSupportDataAccessTypes())) {
                detail.setDataAccesses(new ArrayList());
            } else if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)detail.getDataAccesses()) && !entity.getSupportDataAccessTypes().contains("*")) {
                detail.setDataAccesses(detail.getDataAccesses().stream().filter(access -> entity.getSupportDataAccessTypes().stream().anyMatch(type -> type.startsWith(access.getType()))).collect(Collectors.toList()));
            }
            return true;
        }).collect(Collectors.toList());
        Map<String, List<AuthorizationSettingDetailEntity>> settings = detailList.stream().collect(Collectors.groupingBy(AuthorizationSettingDetailEntity::getPermissionId));
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        Map<String, List<ParentPermission>> parentsPermissions = permissionEntityCache.values().stream().map(PermissionEntity::getParents).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.groupingBy(ParentPermission::getPermission));
        settings.forEach((permissionId, details) -> {
            SimplePermission permission = new SimplePermission();
            permission.setId(permissionId);
            HashSet actions = new HashSet();
            HashSet dataAccessConfigs = new HashSet();
            Collections.sort(details);
            for (AuthorizationSettingDetailEntity detail : details) {
                if (Boolean.FALSE.equals(detail.getMerge())) {
                    actions.clear();
                    dataAccessConfigs.clear();
                }
                if (null != detail.getActions()) {
                    actions.addAll(detail.getActions());
                }
                if (null == detail.getDataAccesses()) continue;
                dataAccessConfigs.addAll(detail.getDataAccesses().stream().map(arg_0 -> ((DataAccessFactory)this.dataAccessFactory).create(arg_0)).collect(Collectors.toSet()));
            }
            List parents = (List)parentsPermissions.get(permissionId);
            if (parents != null) {
                actions.addAll(parents.stream().map(ParentPermission::getActions).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet()));
                parentsPermissions.remove(permissionId);
            }
            permission.setActions(actions);
            permission.setDataAccesses(dataAccessConfigs);
            permissions.add((Permission)permission);
        });
        parentsPermissions.forEach((per, all) -> {
            SimplePermission permission = new SimplePermission();
            permission.setId(per);
            permission.setActions(all.stream().map(ParentPermission::getActions).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet()));
            permissions.add((Permission)permission);
        });
        return permissions;
    }

    @Autowired
    public void setDataAccessFactory(DataAccessFactory dataAccessFactory) {
        this.dataAccessFactory = dataAccessFactory;
    }

    @Autowired
    public void setAuthorizationSettingTypeSuppliers(List<AuthorizationSettingTypeSupplier> authorizationSettingTypeSuppliers) {
        this.authorizationSettingTypeSuppliers = authorizationSettingTypeSuppliers;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Autowired
    public void setAuthorizationSettingDao(AuthorizationSettingDao authorizationSettingDao) {
        this.authorizationSettingDao = authorizationSettingDao;
    }

    @Autowired
    public void setAuthorizationSettingDetailDao(AuthorizationSettingDetailDao authorizationSettingDetailDao) {
        this.authorizationSettingDetailDao = authorizationSettingDetailDao;
    }

    @Autowired
    public void setAuthorizationSettingMenuService(AuthorizationSettingMenuService authorizationSettingMenuService) {
        this.authorizationSettingMenuService = authorizationSettingMenuService;
    }

    @Autowired
    public void setMenuService(MenuService menuService) {
        this.menuService = menuService;
    }

    @Autowired
    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

