/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.authorization.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.utils.ListUtils;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.dao.authorization.RoleDao;
import org.hswebframework.web.dao.authorization.UserDao;
import org.hswebframework.web.dao.authorization.UserRoleDao;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.dao.dynamic.UpdateByEntityDao;
import org.hswebframework.web.entity.authorization.RoleEntity;
import org.hswebframework.web.entity.authorization.UserEntity;
import org.hswebframework.web.entity.authorization.UserRoleEntity;
import org.hswebframework.web.entity.authorization.bind.BindRoleUserEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.AbstractService;
import org.hswebframework.web.service.DefaultDSLQueryService;
import org.hswebframework.web.service.DefaultDSLUpdateService;
import org.hswebframework.web.service.Validator;
import org.hswebframework.web.service.authorization.AuthorizationSettingTypeSupplier;
import org.hswebframework.web.service.authorization.PasswordEncoder;
import org.hswebframework.web.service.authorization.PasswordStrengthValidator;
import org.hswebframework.web.service.authorization.UserService;
import org.hswebframework.web.service.authorization.UsernameValidator;
import org.hswebframework.web.service.authorization.events.ClearUserAuthorizationCacheEvent;
import org.hswebframework.web.service.authorization.events.UserCreatedEvent;
import org.hswebframework.web.service.authorization.events.UserModifiedEvent;
import org.hswebframework.web.validate.ValidationException;
import org.hswebframework.web.validator.group.CreateGroup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Transactional(rollbackFor={Throwable.class})
@Service(value="userService")
public class SimpleUserService
extends AbstractService<UserEntity, String>
implements DefaultDSLQueryService<UserEntity, String>,
UserService,
AuthorizationSettingTypeSupplier {
    @Autowired(required=false)
    private PasswordStrengthValidator passwordStrengthValidator;
    @Autowired(required=false)
    private UsernameValidator usernameValidator;
    @Autowired(required=false)
    private PasswordEncoder passwordEncoder = (password, salt) -> DigestUtils.md5Hex((String)String.format("hsweb.%s.framework.%s", password, salt));
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private ApplicationEventPublisher publisher;

    public String encodePassword(String password, String salt) {
        return this.passwordEncoder.encode(password, salt);
    }

    public UserEntity createEntity() {
        return (UserEntity)this.entityFactory.newInstance(BindRoleUserEntity.class);
    }

    protected IDGenerator<String> getIdGenerator() {
        return IDGenerator.MD5;
    }

    @Transactional(readOnly=true)
    public UserEntity selectByUsername(String username) {
        if (!StringUtils.hasLength((String)username)) {
            return null;
        }
        return (UserEntity)((Query)this.createQuery().where("username", (Object)username)).single();
    }

    @Transactional(readOnly=true)
    public UserEntity selectByUserNameAndPassword(String plainUsername, String plainPassword) {
        Assert.hasLength((String)plainUsername, (String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)plainPassword, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return Optional.ofNullable(this.selectByUsername(plainUsername)).filter(user -> this.encodePassword(plainPassword, user.getSalt()).equals(user.getPassword())).orElse(null);
    }

    @Transactional(readOnly=true)
    public UserEntity selectByPk(String id) {
        if (!StringUtils.hasLength((String)id)) {
            return null;
        }
        UserEntity userEntity = (UserEntity)((Query)this.createQuery().where("id", (Object)id)).single();
        if (null != userEntity) {
            List roleId = this.userRoleDao.selectByUserId(id).stream().map(UserRoleEntity::getRoleId).collect(Collectors.toList());
            BindRoleUserEntity roleUserEntity = (BindRoleUserEntity)this.entityFactory.newInstance(BindRoleUserEntity.class, (Object)userEntity);
            roleUserEntity.setRoles(roleId);
            return roleUserEntity;
        }
        return null;
    }

    public List<UserEntity> selectByPk(List<String> id) {
        if (CollectionUtils.isEmpty(id)) {
            return new ArrayList<UserEntity>();
        }
        return ((Query)((Query)this.createQuery().where()).in("id", id)).listNoPaging();
    }

    @CacheEvict(value={"user-"}, key="#userEntity.id")
    public String insert(UserEntity userEntity) {
        BindRoleUserEntity bindRoleUserEntity;
        this.tryValidateProperty((Validator)this.usernameValidator, "username", userEntity.getUsername());
        this.tryValidateProperty(null == this.selectByUsername(userEntity.getUsername()), "username", "\u7528\u6237\u540d\u5df2\u5b58\u5728");
        this.tryValidateProperty((Validator)this.passwordStrengthValidator, "password", userEntity.getPassword());
        userEntity.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        userEntity.setId(this.getIdGenerator().generate());
        userEntity.setSalt((String)IDGenerator.RANDOM.generate());
        userEntity.setStatus(DataStatus.STATUS_ENABLED);
        this.tryValidate(userEntity, new Class[]{CreateGroup.class});
        userEntity.setPassword(this.encodePassword(userEntity.getPassword(), userEntity.getSalt()));
        this.userDao.insert(userEntity);
        if (userEntity instanceof BindRoleUserEntity && !ListUtils.isNullOrEmpty((List)(bindRoleUserEntity = (BindRoleUserEntity)userEntity).getRoles())) {
            this.trySyncUserRole((String)userEntity.getId(), bindRoleUserEntity.getRoles());
        }
        this.publisher.publishEvent((Object)new UserCreatedEvent(userEntity));
        return (String)userEntity.getId();
    }

    protected void trySyncUserRole(String userId, List<String> roleIdList) {
        new HashSet<String>(roleIdList).stream().map(roleId -> {
            UserRoleEntity roleEntity = (UserRoleEntity)this.entityFactory.newInstance(UserRoleEntity.class);
            roleEntity.setRoleId(roleId);
            roleEntity.setUserId(userId);
            return roleEntity;
        }).forEach(this.userRoleDao::insert);
    }

    @Caching(evict={@CacheEvict(value={"user-"}, key="#userId")})
    public void update(String userId, UserEntity userEntity) {
        BindRoleUserEntity bindRoleUserEntity;
        userEntity.setId((Object)userId);
        UserEntity oldUser = this.selectByPk(userId);
        SimpleUserService.assertNotNull((Object)oldUser);
        boolean roleModified = false;
        boolean passwordModified = false;
        ArrayList<String> excludeProperties = new ArrayList<String>(Arrays.asList("username", "password", "salt", "status"));
        if (StringUtils.hasLength((String)userEntity.getPassword())) {
            this.tryValidateProperty((Validator)this.passwordStrengthValidator, "password", userEntity.getPassword());
            userEntity.setPassword(this.encodePassword(userEntity.getPassword(), oldUser.getSalt()));
            excludeProperties.remove("password");
            passwordModified = true;
        }
        ((Update)DefaultDSLUpdateService.createUpdate((UpdateByEntityDao)this.getDao(), (Object)userEntity).excludes(excludeProperties.toArray(new String[excludeProperties.size()])).where("id", userEntity.getId())).exec();
        if (userEntity instanceof BindRoleUserEntity && (bindRoleUserEntity = (BindRoleUserEntity)userEntity).getRoles() != null) {
            this.userRoleDao.deleteByUserId((String)bindRoleUserEntity.getId());
            this.trySyncUserRole((String)userEntity.getId(), bindRoleUserEntity.getRoles());
            roleModified = true;
        }
        if (excludeProperties.contains("password")) {
            this.publisher.publishEvent((Object)new UserModifiedEvent(userEntity, passwordModified, roleModified));
        }
        this.publisher.publishEvent((Object)new ClearUserAuthorizationCacheEvent(userId, false));
    }

    public boolean enable(String userId) {
        if (!StringUtils.hasLength((String)userId)) {
            return false;
        }
        return ((Update)DefaultDSLUpdateService.createUpdate((UpdateByEntityDao)this.getDao()).set("status", (Object)DataStatus.STATUS_ENABLED).where("id", (Object)userId)).exec() > 0;
    }

    public boolean disable(String userId) {
        if (!StringUtils.hasLength((String)userId)) {
            return false;
        }
        return ((Update)DefaultDSLUpdateService.createUpdate((UpdateByEntityDao)this.getDao()).set("status", (Object)DataStatus.STATUS_DISABLED).where("id", (Object)userId)).exec() > 0;
    }

    public void updatePassword(String userId, String oldPassword, String newPassword) {
        UserEntity userEntity = this.selectByPk(userId);
        SimpleUserService.assertNotNull((Object)userEntity);
        oldPassword = this.encodePassword(oldPassword, userEntity.getSalt());
        if (!userEntity.getPassword().equals(oldPassword)) {
            throw new ValidationException("\u5bc6\u7801\u9519\u8bef", "password");
        }
        this.tryValidateProperty((Validator)this.passwordStrengthValidator, "password", newPassword);
        newPassword = this.encodePassword(newPassword, userEntity.getSalt());
        ((Update)DefaultDSLUpdateService.createUpdate((UpdateByEntityDao)this.getDao()).set("password", (Object)newPassword).where("id", (Object)userId)).exec();
        this.publisher.publishEvent((Object)new UserModifiedEvent(userEntity, true, false));
    }

    public List<RoleEntity> getUserRole(String userId) {
        Assert.hasLength((String)userId, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List<UserRoleEntity> roleEntities = this.userRoleDao.selectByUserId(userId);
        if (roleEntities.isEmpty()) {
            return new ArrayList<RoleEntity>();
        }
        List roleIdList = roleEntities.stream().map(UserRoleEntity::getRoleId).collect(Collectors.toList());
        return ((Query)((Query)DefaultDSLQueryService.createQuery((QueryByEntityDao)this.roleDao).where()).in("id", roleIdList)).noPaging().list();
    }

    public UserDao getDao() {
        return this.userDao;
    }

    public Set<AuthorizationSettingTypeSupplier.SettingInfo> get(String userId) {
        UserEntity userEntity = this.selectByPk(userId);
        if (null == userEntity) {
            return new HashSet<AuthorizationSettingTypeSupplier.SettingInfo>();
        }
        List<UserRoleEntity> roleEntities = this.userRoleDao.selectByUserId(userId);
        Set<AuthorizationSettingTypeSupplier.SettingInfo> settingInfo = roleEntities.stream().map(entity -> new AuthorizationSettingTypeSupplier.SettingInfo("role", entity.getRoleId())).collect(Collectors.toSet());
        settingInfo.add(new AuthorizationSettingTypeSupplier.SettingInfo("user", userId));
        return settingInfo;
    }

    public List<UserEntity> selectByUserByRole(List<String> roleIdList) {
        if (CollectionUtils.isEmpty(roleIdList)) {
            return new ArrayList<UserEntity>();
        }
        return this.createQuery().where("id", "user-in-role", roleIdList).listNoPaging();
    }
}

