/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.authorization.simple;

import java.util.function.Supplier;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationInitializeService;
import org.hswebframework.web.authorization.AuthenticationManager;
import org.hswebframework.web.authorization.AuthenticationRequest;
import org.hswebframework.web.authorization.simple.PlainTextUsernamePasswordAuthenticationRequest;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.entity.authorization.UserEntity;
import org.hswebframework.web.service.authorization.UserService;
import org.hswebframework.web.validate.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachePut;

public class SimpleAuthenticationManager
implements AuthenticationManager {
    private AuthenticationInitializeService authenticationInitializeService;
    private AuthenticationManager parent;
    @Autowired
    private UserService userService;
    @Autowired(required=false)
    private CacheManager cacheManager;

    public SimpleAuthenticationManager() {
    }

    public SimpleAuthenticationManager(AuthenticationInitializeService authenticationInitializeService) {
        this.authenticationInitializeService = authenticationInitializeService;
    }

    public SimpleAuthenticationManager(AuthenticationInitializeService authenticationInitializeService, AuthenticationManager parent) {
        this.authenticationInitializeService = authenticationInitializeService;
        this.parent = parent;
    }

    @Autowired
    public void setAuthenticationInitializeService(AuthenticationInitializeService authenticationInitializeService) {
        this.authenticationInitializeService = authenticationInitializeService;
    }

    public Authentication authenticate(AuthenticationRequest request) {
        if (null != this.parent) {
            try {
                Authentication authentication = this.parent.authenticate(request);
                if (null != authentication) {
                    return authentication;
                }
            }
            catch (Exception authentication) {
                // empty catch block
            }
        }
        if (request instanceof PlainTextUsernamePasswordAuthenticationRequest) {
            String password;
            String username = ((PlainTextUsernamePasswordAuthenticationRequest)request).getUsername();
            UserEntity userEntity = this.userService.selectByUserNameAndPassword(username, password = ((PlainTextUsernamePasswordAuthenticationRequest)request).getPassword());
            if (userEntity == null) {
                throw new ValidationException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            }
            if (!DataStatus.STATUS_ENABLED.equals(userEntity.getStatus())) {
                throw new ValidationException("\u7528\u6237\u5df2\u88ab\u7981\u7528", "username");
            }
            return this.getByUserId((String)userEntity.getId());
        }
        return null;
    }

    public Authentication getByUserId(String userId) {
        Supplier<Authentication> supplier = () -> {
            Authentication authentication = null;
            if (this.parent != null) {
                authentication = this.parent.getByUserId(userId);
            }
            if (authentication == null) {
                authentication = this.authenticationInitializeService.initUserAuthorization(userId);
            }
            return authentication;
        };
        if (null != this.cacheManager) {
            Cache cache = this.cacheManager.getCache("user-auth-");
            Cache.ValueWrapper wrapper = cache.get((Object)userId);
            if (wrapper == null) {
                Authentication authentication = supplier.get();
                cache.put((Object)userId, (Object)authentication);
                return authentication;
            }
            return (Authentication)wrapper.get();
        }
        return supplier.get();
    }

    @CachePut(value={"user-auth-"}, key="#authentication.user.id")
    public Authentication sync(Authentication authentication) {
        if (this.parent != null) {
            this.parent.sync(authentication);
        }
        return authentication;
    }

    public void setParent(AuthenticationManager parent) {
        this.parent = parent;
    }

    public AuthenticationManager getParent() {
        return this.parent;
    }
}

