/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.authorization.simple;

import org.hswebframework.web.authorization.setting.SettingValueHolder;
import org.hswebframework.web.authorization.setting.StringSourceSettingHolder;
import org.hswebframework.web.authorization.setting.UserSettingManager;
import org.hswebframework.web.authorization.setting.UserSettingPermission;
import org.hswebframework.web.entity.authorization.UserSettingEntity;
import org.hswebframework.web.service.authorization.UserSettingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InServiceUserSettingManager
implements UserSettingManager {
    @Autowired
    private UserSettingService userSettingService;

    public SettingValueHolder getSetting(String userId, String key) {
        UserSettingEntity entity = this.userSettingService.selectByUser(userId, "user-setting", key);
        if (entity == null) {
            return SettingValueHolder.NULL;
        }
        return StringSourceSettingHolder.of((String)entity.getSetting(), (UserSettingPermission)entity.getPermission());
    }

    public void saveSetting(String userId, String key, String value, UserSettingPermission permission) {
        UserSettingEntity entity = new UserSettingEntity();
        entity.setUserId(userId);
        entity.setKey("user-setting");
        entity.setSettingId(key);
        entity.setSetting(value);
        entity.setPermission(permission);
        this.userSettingService.saveOrUpdate((Object)entity);
    }
}

