/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.webflux;

import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.DeleteAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.system.authorization.api.entity.DimensionUserEntity;
import org.hswebframework.web.system.authorization.defaults.service.DefaultDimensionUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/dimension-user"})
@Authorize
@Resource(id="dimension", name="\u6743\u9650\u7ef4\u5ea6\u7ba1\u7406", group={"system"})
public class WebFluxDimensionUserController
implements ReactiveServiceCrudController<DimensionUserEntity, String> {
    @Autowired
    private DefaultDimensionUserService dimensionUserService;

    public ReactiveCrudService<DimensionUserEntity, String> getService() {
        return this.dimensionUserService;
    }

    @DeleteAction
    @DeleteMapping(value={"/user/{userId}/dimension/{dimensionId}"})
    public Mono<Integer> deleteByUserAndDimensionId(@PathVariable String userId, @PathVariable String dimensionId) {
        return ((ReactiveDelete)((ReactiveDelete)this.dimensionUserService.createDelete().where(DimensionUserEntity::getUserId, (Object)userId)).and(DimensionUserEntity::getDimensionId, (Object)dimensionId)).execute();
    }

    @DeleteAction
    @DeleteMapping(value={"/user/{userId}"})
    public Mono<Integer> deleteByUserId(@PathVariable String userId) {
        return ((ReactiveDelete)this.dimensionUserService.createDelete().where(DimensionUserEntity::getUserId, (Object)userId)).execute();
    }

    @DeleteAction
    @DeleteMapping(value={"/dimension/{dimensionId}"})
    public Mono<Integer> deleteByDimension(@PathVariable String dimensionId) {
        return ((ReactiveDelete)this.dimensionUserService.createDelete().where(DimensionUserEntity::getDimensionId, (Object)dimensionId)).execute();
    }
}

