/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.authorization.DimensionProvider;
import org.hswebframework.web.authorization.DimensionType;
import org.hswebframework.web.crud.service.GenericReactiveTreeSupportCrudService;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.system.authorization.api.entity.AuthorizationSettingEntity;
import org.hswebframework.web.system.authorization.api.entity.DimensionEntity;
import org.hswebframework.web.system.authorization.api.entity.DimensionTypeEntity;
import org.hswebframework.web.system.authorization.api.entity.DimensionUserEntity;
import org.hswebframework.web.system.authorization.api.event.ClearUserAuthorizationCacheEvent;
import org.hswebframework.web.system.authorization.defaults.service.DynamicDimension;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultDimensionService
extends GenericReactiveTreeSupportCrudService<DimensionEntity, String>
implements DimensionProvider {
    @Autowired
    private ReactiveRepository<DimensionUserEntity, String> dimensionUserRepository;
    @Autowired
    private ReactiveRepository<DimensionTypeEntity, String> dimensionTypeRepository;
    @Autowired
    private ReactiveRepository<AuthorizationSettingEntity, String> settingRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public void setChildren(DimensionEntity entity, List<DimensionEntity> children) {
        entity.setChildren(children);
    }

    public Flux<DimensionTypeEntity> getAllType() {
        return this.dimensionTypeRepository.createQuery().fetch();
    }

    public Mono<DynamicDimension> getDimensionById(DimensionType type, String id) {
        return ((ReactiveQuery)this.createQuery().where(GenericEntity::getId, (Object)id)).fetch().singleOrEmpty().map(entity -> DynamicDimension.of(entity, type));
    }

    public Flux<DynamicDimension> getDimensionByUserId(String userId) {
        return this.getAllType().collect(Collectors.toMap(DimensionType::getId, Function.identity())).flatMapMany(typeGrouping -> ((ReactiveQuery)this.dimensionUserRepository.createQuery().where(DimensionUserEntity::getUserId, (Object)userId)).fetch().collectList().filter(CollectionUtils::isNotEmpty).flatMapMany(list -> this.queryIncludeChildren(list.stream().map(DimensionUserEntity::getDimensionId).collect(Collectors.toSet())).filter(dimension -> typeGrouping.containsKey(dimension.getTypeId())).map(dimension -> DynamicDimension.of(dimension, (DimensionType)typeGrouping.get(dimension.getTypeId())))));
    }

    public Flux<String> getUserIdByDimensionId(String dimensionId) {
        return ((ReactiveQuery)((ReactiveQuery)this.dimensionUserRepository.createQuery().select(new StaticMethodReferenceColumn[]{DimensionUserEntity::getUserId})).where(DimensionUserEntity::getDimensionId, (Object)dimensionId)).fetch().map(DimensionUserEntity::getUserId);
    }

    public Mono<SaveResult> save(Publisher<DimensionEntity> entityPublisher) {
        return super.save(entityPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.all()));
    }

    public Mono<Integer> updateById(String id, Mono<DimensionEntity> entityPublisher) {
        return super.updateById((Object)id, entityPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.all()));
    }

    public ReactiveUpdate<DimensionEntity> createUpdate() {
        return super.createUpdate().onExecute((update, result) -> result.doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.all())));
    }

    public ReactiveDelete createDelete() {
        return super.createDelete().onExecute((delete, result) -> result.doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.all())));
    }

    public Mono<Integer> deleteById(Publisher<String> idPublisher) {
        return Flux.from(idPublisher).collectList().flatMap(list -> super.queryIncludeChildren((Collection)list).flatMap(dimension -> ((ReactiveDelete)((ReactiveDelete)this.dimensionUserRepository.createDelete().where()).is(DimensionUserEntity::getDimensionId, dimension.getId())).execute().then(this.getRepository().deleteById((Publisher)Mono.just((Object)dimension.getId()))).thenReturn(dimension)).groupBy(DimensionEntity::getTypeId, GenericEntity::getId).flatMap(grouping -> grouping.collectList().flatMap(dimensionId -> ((ReactiveDelete)((ReactiveDelete)this.settingRepository.createDelete().where(AuthorizationSettingEntity::getDimensionType, grouping.key())).in(AuthorizationSettingEntity::getDimensionTarget, (Collection)dimensionId)).execute())).collect(Collectors.summarizingInt(Integer::intValue)).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.all())).thenReturn((Object)list.size()));
    }
}

