/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.authorization.DimensionProvider;
import org.hswebframework.web.authorization.DimensionType;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.system.authorization.api.entity.AuthorizationSettingEntity;
import org.hswebframework.web.system.authorization.api.event.ClearUserAuthorizationCacheEvent;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class DefaultAuthorizationSettingService
extends GenericReactiveCrudService<AuthorizationSettingEntity, String> {
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private List<DimensionProvider> providers;

    protected AuthorizationSettingEntity generateId(AuthorizationSettingEntity entity) {
        if (StringUtils.isEmpty((Object)entity.getId())) {
            entity.setId(DigestUtils.md5Hex((String)(entity.getPermission() + entity.getDimensionType() + entity.getDimensionTarget())));
        }
        return entity;
    }

    public Mono<SaveResult> save(Publisher<AuthorizationSettingEntity> entityPublisher) {
        return Flux.from(entityPublisher).map(this::generateId).collectList().flatMap(autz -> super.save((Publisher)Flux.fromIterable((Iterable)autz)).doOnSuccess(r -> this.clearUserAuthCache((List<AuthorizationSettingEntity>)autz)));
    }

    public Mono<Integer> updateById(String id, Mono<AuthorizationSettingEntity> entityPublisher) {
        return entityPublisher.flatMap(autz -> super.updateById((Object)id, Mono.just((Object)autz)).doOnSuccess(r -> this.clearUserAuthCache(Collections.singletonList(autz))));
    }

    public Mono<Integer> deleteById(Publisher<String> idPublisher) {
        return Flux.from(idPublisher).collectList().flatMap(list -> super.deleteById((Publisher)Flux.fromIterable((Iterable)list)).flatMap(r -> this.findById(Flux.fromIterable((Iterable)list)).collectList().doOnSuccess(this::clearUserAuthCache).thenReturn(r)));
    }

    public Mono<Integer> insert(Publisher<AuthorizationSettingEntity> entityPublisher) {
        return Flux.from(entityPublisher).map(this::generateId).collectList().flatMap(list -> super.insert((Publisher)Flux.fromIterable((Iterable)list)).doOnSuccess(i -> this.clearUserAuthCache((List<AuthorizationSettingEntity>)list)));
    }

    public Mono<Integer> insertBatch(Publisher<? extends Collection<AuthorizationSettingEntity>> entityPublisher) {
        return Flux.from(entityPublisher).collectList().flatMap(list -> super.insertBatch((Publisher)Flux.fromStream(list.stream().map(lst -> lst.stream().map(this::generateId).collect(Collectors.toList())))).doOnSuccess(i -> this.clearUserAuthCache(list.stream().flatMap(Collection::stream).collect(Collectors.toList()))));
    }

    public ReactiveUpdate<AuthorizationSettingEntity> createUpdate() {
        return super.createUpdate().onExecute((update, r) -> r.doOnSuccess(i -> ((ReactiveQuery)this.createQuery().setParam(update.toQueryParam())).fetch().collectList().subscribe(this::clearUserAuthCache)));
    }

    public ReactiveDelete createDelete() {
        return super.createDelete().onExecute((delete, r) -> r.doOnSuccess(i -> ((ReactiveQuery)this.createQuery().setParam(delete.toQueryParam())).fetch().collectList().subscribe(this::clearUserAuthCache)));
    }

    protected void clearUserAuthCache(List<AuthorizationSettingEntity> settings) {
        Flux.fromIterable(this.providers).flatMap(provider -> provider.getAllType().map(DimensionType::getId).map(t -> Tuples.of((Object)t, (Object)provider))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2)).flatMapMany(typeProviderMapping -> Flux.fromIterable((Iterable)settings).flatMap(setting -> Mono.justOrEmpty(typeProviderMapping.get(setting.getDimensionType())).flatMapMany(provider -> provider.getUserIdByDimensionId(setting.getDimensionTarget())))).collectList().map(ClearUserAuthorizationCacheEvent::of).subscribe(arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0));
    }
}

