/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.validation.ValidationException;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.SyncQuery;
import org.hswebframework.ezorm.rdb.mapping.SyncUpdate;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.crud.service.GenericCrudService;
import org.hswebframework.web.exception.NotFoundException;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.system.authorization.api.PasswordEncoder;
import org.hswebframework.web.system.authorization.api.entity.UserEntity;
import org.hswebframework.web.system.authorization.api.event.UserCreatedEvent;
import org.hswebframework.web.system.authorization.api.event.UserModifiedEvent;
import org.hswebframework.web.system.authorization.api.service.UserService;
import org.hswebframework.web.validator.CreateGroup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

@Transactional(rollbackFor={Exception.class})
public class DefaultUserService
extends GenericCrudService<UserEntity, String>
implements UserService {
    @Autowired(required=false)
    private PasswordEncoder passwordEncoder = (password, salt) -> DigestUtils.md5Hex((String)String.format("hsweb.%s.framework.%s", password, salt));
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public boolean saveUser(UserEntity userEntity) {
        if (StringUtils.isEmpty((Object)userEntity.getId())) {
            return this.doAdd(userEntity);
        }
        UserEntity old = this.findById(userEntity.getId()).orElse(null);
        if (old == null) {
            return this.doAdd(userEntity);
        }
        return this.doUpdate(userEntity);
    }

    protected boolean doAdd(UserEntity userEntity) {
        userEntity.tryValidate(new Class[]{CreateGroup.class});
        userEntity.setStatus(Byte.valueOf((byte)1));
        userEntity.setSalt((String)IDGenerator.RANDOM.generate());
        userEntity.setPassword(this.passwordEncoder.encode(userEntity.getPassword(), userEntity.getSalt()));
        if (((SyncQuery)this.createQuery().where(() -> ((UserEntity)userEntity).getUsername())).count() > 0) {
            throw new ValidationException("\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        this.getRepository().insert((Object)userEntity);
        this.eventPublisher.publishEvent((Object)new UserCreatedEvent(userEntity));
        return true;
    }

    protected boolean doUpdate(UserEntity userEntity) {
        boolean passwordChanged = StringUtils.hasText((String)userEntity.getPassword());
        if (passwordChanged) {
            userEntity.setSalt((String)IDGenerator.RANDOM.generate());
            userEntity.setPassword(this.passwordEncoder.encode(userEntity.getPassword(), userEntity.getSalt()));
        }
        ((SyncUpdate)((SyncUpdate)this.getRepository().createUpdate().set((Object)userEntity)).where(() -> ((UserEntity)userEntity).getId())).execute();
        this.eventPublisher.publishEvent((Object)new UserModifiedEvent(userEntity, passwordChanged));
        return true;
    }

    @Transactional(readOnly=true)
    public List<UserEntity> findById(Collection<String> id) {
        return super.findById(id);
    }

    @Transactional(readOnly=true)
    public Optional<UserEntity> findById(String id) {
        return super.findById((Object)id);
    }

    @Transactional(readOnly=true)
    public Optional<UserEntity> findByUsername(String username) {
        return ((SyncQuery)this.createQuery().where(UserEntity::getUsername, (Object)username)).fetchOne();
    }

    @Transactional(readOnly=true)
    public Optional<UserEntity> findByUsernameAndPassword(String username, String plainPassword) {
        return this.findByUsername(username).filter(user -> this.passwordEncoder.encode(plainPassword, user.getSalt()).equals(user.getPassword()));
    }

    public boolean changeState(String userId, byte state) {
        return ((SyncUpdate)((SyncUpdate)this.createUpdate().where(UserEntity::getId, (Object)userId)).set(UserEntity::getStatus, (Object)state)).execute() > 0;
    }

    public void changePassword(String userId, String oldPassword, String newPassword) {
        Mono.justOrEmpty(this.findById(userId)).switchIfEmpty(Mono.error(NotFoundException::new)).filter(user -> this.passwordEncoder.encode(oldPassword, user.getSalt()).equals(user.getPassword())).switchIfEmpty(Mono.error(() -> new ValidationException("\u5bc6\u7801\u9519\u8bef"))).map(user -> ((SyncUpdate)((SyncUpdate)this.createUpdate().set(UserEntity::getPassword, (Object)this.passwordEncoder.encode(newPassword, user.getSalt()))).where(() -> ((UserEntity)user).getId())).execute()).block();
    }

    @Transactional(readOnly=true)
    public List<UserEntity> findUser(QueryParam queryParam) {
        return ((SyncQuery)this.createQuery().setParam(queryParam)).fetch();
    }

    @Transactional(readOnly=true)
    public long countUser(QueryParam queryParam) {
        return ((SyncQuery)this.createQuery().setParam(queryParam)).count();
    }

    public PagerResult<UserEntity> findUserPager(QueryParam param) {
        return this.queryPager(param);
    }
}

