/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import java.util.Collection;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.system.authorization.api.entity.DimensionUserEntity;
import org.hswebframework.web.system.authorization.api.event.ClearUserAuthorizationCacheEvent;
import org.hswebframework.web.system.authorization.api.event.UserDeletedEvent;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultDimensionUserService
extends GenericReactiveCrudService<DimensionUserEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(DefaultDimensionUserService.class);
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    @EventListener
    public void handleUserDeleteEntity(UserDeletedEvent event) {
        ((ReactiveDelete)this.createDelete().where(DimensionUserEntity::getUserId, (Object)event.getUser().getId())).execute().subscribe(i -> log.debug("user deleted,clear user dimension!"));
    }

    public Mono<SaveResult> save(Publisher<DimensionUserEntity> entityPublisher) {
        return (Mono)Flux.from(entityPublisher).doOnNext(entity -> this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.of((String[])new String[]{entity.getUserId()}))).as(x$0 -> super.save(x$0));
    }

    public Mono<Integer> updateById(String id, Mono<DimensionUserEntity> entityPublisher) {
        return (Mono)entityPublisher.doOnNext(entity -> this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.of((String[])new String[]{entity.getUserId()}))).as(e -> super.updateById((Object)id, e));
    }

    public Mono<Integer> insert(Publisher<DimensionUserEntity> entityPublisher) {
        return (Mono)Flux.from(entityPublisher).doOnNext(entity -> this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.of((String[])new String[]{entity.getUserId()}))).as(x$0 -> super.insert(x$0));
    }

    public Mono<Integer> insertBatch(Publisher<? extends Collection<DimensionUserEntity>> entityPublisher) {
        return (Mono)Flux.from(entityPublisher).doOnNext(entity -> this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.of((Collection)entity.stream().map(DimensionUserEntity::getUserId).collect(Collectors.toSet())))).as(x$0 -> super.insertBatch(x$0));
    }

    public Mono<Integer> deleteById(Publisher<String> idPublisher) {
        return (Mono)this.findById(Flux.from(idPublisher)).doOnNext(entity -> this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.of((String[])new String[]{entity.getUserId()}))).map(GenericEntity::getId).as(x$0 -> super.deleteById(x$0));
    }

    public ReactiveUpdate<DimensionUserEntity> createUpdate() {
        return super.createUpdate().onExecute((update, r) -> r.doOnSuccess(i -> ((ReactiveQuery)((ReactiveQuery)this.createQuery().select(new StaticMethodReferenceColumn[]{DimensionUserEntity::getUserId})).setParam(update.toQueryParam())).fetch().map(DimensionUserEntity::getUserId).collectList().map(ClearUserAuthorizationCacheEvent::of).subscribe()));
    }

    public ReactiveDelete createDelete() {
        return super.createDelete().onExecute((delete, r) -> r.doOnSuccess(i -> ((ReactiveQuery)((ReactiveQuery)this.createQuery().select(new StaticMethodReferenceColumn[]{DimensionUserEntity::getUserId})).setParam(delete.toQueryParam())).fetch().map(DimensionUserEntity::getUserId).collectList().map(ClearUserAuthorizationCacheEvent::of).subscribe()));
    }
}

