/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.DimensionProvider;
import org.hswebframework.web.authorization.DimensionType;
import org.hswebframework.web.authorization.dimension.DimensionUserBind;
import org.hswebframework.web.authorization.dimension.DimensionUserBindProvider;
import org.hswebframework.web.crud.events.EntityDeletedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.crud.service.GenericReactiveTreeSupportCrudService;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.system.authorization.api.entity.DimensionEntity;
import org.hswebframework.web.system.authorization.api.entity.DimensionTypeEntity;
import org.hswebframework.web.system.authorization.api.entity.DimensionUserEntity;
import org.hswebframework.web.system.authorization.api.event.ClearUserAuthorizationCacheEvent;
import org.hswebframework.web.system.authorization.api.event.DimensionDeletedEvent;
import org.hswebframework.web.system.authorization.defaults.service.DynamicDimension;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultDimensionService
extends GenericReactiveTreeSupportCrudService<DimensionEntity, String>
implements DimensionProvider,
DimensionUserBindProvider {
    @Autowired
    private ReactiveRepository<DimensionUserEntity, String> dimensionUserRepository;
    @Autowired
    private ReactiveRepository<DimensionTypeEntity, String> dimensionTypeRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public void setChildren(DimensionEntity entity, List<DimensionEntity> children) {
        entity.setChildren(children);
    }

    public Flux<DimensionTypeEntity> getAllType() {
        return this.dimensionTypeRepository.createQuery().fetch();
    }

    public Mono<DynamicDimension> getDimensionById(DimensionType type, String id) {
        return ((ReactiveQuery)this.createQuery().where(DimensionEntity::getId, (Object)id)).fetch().singleOrEmpty().map(entity -> DynamicDimension.of(entity, type));
    }

    public Flux<? extends Dimension> getDimensionsById(DimensionType type, Collection<String> idList) {
        return ((ReactiveQuery)((ReactiveQuery)this.createQuery().where(DimensionEntity::getTypeId, (Object)type.getId())).in(DimensionEntity::getId, idList)).fetch().map(entity -> DynamicDimension.of(entity, type));
    }

    public Flux<DynamicDimension> getDimensionByUserId(String userId) {
        return this.getAllType().collect(Collectors.toMap(DimensionType::getId, Function.identity())).flatMapMany(typeGrouping -> ((ReactiveQuery)this.dimensionUserRepository.createQuery().where(DimensionUserEntity::getUserId, (Object)userId)).fetch().collectList().filter(CollectionUtils::isNotEmpty).flatMapMany(list -> this.queryIncludeChildren(list.stream().map(DimensionUserEntity::getDimensionId).collect(Collectors.toSet())).filter(dimension -> typeGrouping.containsKey(dimension.getTypeId())).map(dimension -> DynamicDimension.of(dimension, (DimensionType)typeGrouping.get(dimension.getTypeId())))));
    }

    public Flux<DimensionUserBind> getDimensionBindInfo(Collection<String> userIdList) {
        return ((ReactiveQuery)this.dimensionUserRepository.createQuery().in(DimensionUserEntity::getUserId, userIdList)).fetch().map(entity -> DimensionUserBind.of((String)entity.getUserId(), (String)entity.getDimensionTypeId(), (String)entity.getDimensionId()));
    }

    public Flux<String> getUserIdByDimensionId(String dimensionId) {
        return ((ReactiveQuery)((ReactiveQuery)this.dimensionUserRepository.createQuery().select(new StaticMethodReferenceColumn[]{DimensionUserEntity::getUserId})).where(DimensionUserEntity::getDimensionId, (Object)dimensionId)).fetch().map(DimensionUserEntity::getUserId);
    }

    @EventListener
    public void handleDimensionChanged(EntitySavedEvent<DimensionEntity> event) {
        this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.all());
    }

    @EventListener
    public void handleDimensionChanged(EntityModifyEvent<DimensionEntity> event) {
        this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.all());
    }

    @EventListener
    public void dispatchDimensionDeleteEvent(EntityDeletedEvent<DimensionEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).flatMap(e -> new DimensionDeletedEvent(e.getTypeId(), e.getId()).publish(this.eventPublisher)));
    }
}

