/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.authorization.DimensionProvider;
import org.hswebframework.web.authorization.DimensionType;
import org.hswebframework.web.crud.events.EntityCreatedEvent;
import org.hswebframework.web.crud.events.EntityDeletedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.system.authorization.api.entity.AuthorizationSettingEntity;
import org.hswebframework.web.system.authorization.api.event.ClearUserAuthorizationCacheEvent;
import org.hswebframework.web.system.authorization.api.event.DimensionDeletedEvent;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class DefaultAuthorizationSettingService
extends GenericReactiveCrudService<AuthorizationSettingEntity, String> {
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private List<DimensionProvider> providers;

    protected AuthorizationSettingEntity generateId(AuthorizationSettingEntity entity) {
        if (StringUtils.isEmpty((Object)entity.getId())) {
            entity.setId(DigestUtils.md5Hex((String)(entity.getPermission() + entity.getDimensionType() + entity.getDimensionTarget())));
        }
        return entity;
    }

    public Mono<SaveResult> save(AuthorizationSettingEntity data) {
        this.generateId(data);
        return super.save((Object)data);
    }

    public Mono<SaveResult> save(Collection<AuthorizationSettingEntity> collection) {
        collection.forEach(this::generateId);
        return super.save(collection);
    }

    public Mono<SaveResult> save(Publisher<AuthorizationSettingEntity> entityPublisher) {
        return (Mono)Flux.from(entityPublisher).map(this::generateId).as(x$0 -> super.save(x$0));
    }

    public Mono<Integer> insert(Publisher<AuthorizationSettingEntity> entityPublisher) {
        return (Mono)Flux.from(entityPublisher).map(this::generateId).as(x$0 -> super.insert(x$0));
    }

    public Mono<Integer> insertBatch(Publisher<? extends Collection<AuthorizationSettingEntity>> entityPublisher) {
        return (Mono)Flux.from(entityPublisher).doOnNext(list -> list.forEach(this::generateId)).as(x$0 -> super.insertBatch(x$0));
    }

    protected Mono<Void> clearUserAuthCache(List<AuthorizationSettingEntity> settings) {
        return Flux.fromIterable(this.providers).flatMap(provider -> provider.getAllType().map(DimensionType::getId).map(t -> Tuples.of((Object)t, (Object)provider))).collectMap(Tuple2::getT1, Tuple2::getT2).flatMapMany(typeProviderMapping -> Flux.fromIterable((Iterable)settings).flatMap(setting -> Mono.justOrEmpty(typeProviderMapping.get(setting.getDimensionType())).flatMapMany(provider -> provider.getUserIdByDimensionId(setting.getDimensionTarget())))).collectList().flatMap(lst -> ClearUserAuthorizationCacheEvent.of((Collection)lst).publish(this.eventPublisher)).then();
    }

    @EventListener
    public void handleAuthSettingDeleted(EntityDeletedEvent<AuthorizationSettingEntity> event) {
        event.async(this.clearUserAuthCache(event.getEntity()));
    }

    @EventListener
    public void handleAuthSettingChanged(EntityModifyEvent<AuthorizationSettingEntity> event) {
        event.async(this.clearUserAuthCache(event.getAfter()));
    }

    @EventListener
    public void handleAuthSettingSaved(EntitySavedEvent<AuthorizationSettingEntity> event) {
        event.async(this.clearUserAuthCache(event.getEntity()));
    }

    @EventListener
    public void handleAuthSettingAdded(EntityCreatedEvent<AuthorizationSettingEntity> event) {
        event.async(this.clearUserAuthCache(event.getEntity()));
    }

    @EventListener
    public void handleDimensionAdd(DimensionDeletedEvent event) {
        event.async((Publisher)((ReactiveDelete)((ReactiveDelete)this.createDelete().where(AuthorizationSettingEntity::getDimensionType, (Object)event.getDimensionType())).and(AuthorizationSettingEntity::getDimensionTarget, (Object)event.getDimensionId())).execute());
    }

    @EventListener
    public void handleDimensionDeletedEvent(DimensionDeletedEvent event) {
        event.async((Publisher)((ReactiveDelete)((ReactiveDelete)this.createDelete().where(AuthorizationSettingEntity::getDimensionType, (Object)event.getDimensionType())).and(AuthorizationSettingEntity::getDimensionTarget, (Object)event.getDimensionId())).execute());
    }
}

