/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.configuration;

import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.web.authorization.ReactiveAuthenticationInitializeService;
import org.hswebframework.web.authorization.ReactiveAuthenticationManagerProvider;
import org.hswebframework.web.authorization.define.AuthorizeDefinitionCustomizer;
import org.hswebframework.web.authorization.define.CompositeAuthorizeDefinitionCustomizer;
import org.hswebframework.web.authorization.simple.DefaultAuthorizationAutoConfiguration;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.system.authorization.api.entity.PermissionEntity;
import org.hswebframework.web.system.authorization.api.service.reactive.ReactiveUserService;
import org.hswebframework.web.system.authorization.defaults.configuration.PermissionProperties;
import org.hswebframework.web.system.authorization.defaults.service.DefaultAuthorizationSettingService;
import org.hswebframework.web.system.authorization.defaults.service.DefaultDimensionService;
import org.hswebframework.web.system.authorization.defaults.service.DefaultDimensionUserService;
import org.hswebframework.web.system.authorization.defaults.service.DefaultPermissionService;
import org.hswebframework.web.system.authorization.defaults.service.DefaultReactiveAuthenticationInitializeService;
import org.hswebframework.web.system.authorization.defaults.service.DefaultReactiveAuthenticationManager;
import org.hswebframework.web.system.authorization.defaults.service.DefaultReactiveUserService;
import org.hswebframework.web.system.authorization.defaults.service.PermissionSynchronization;
import org.hswebframework.web.system.authorization.defaults.service.RemoveUserTokenWhenUserDisabled;
import org.hswebframework.web.system.authorization.defaults.service.terms.DimensionTerm;
import org.hswebframework.web.system.authorization.defaults.service.terms.UserDimensionTerm;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthorizationServiceAutoConfiguration {
    @Bean
    public UserDimensionTerm userDimensionTerm() {
        return new UserDimensionTerm();
    }

    @Bean
    public DimensionTerm dimensionTerm() {
        return new DimensionTerm();
    }

    @Bean
    public PermissionProperties permissionProperties() {
        return new PermissionProperties();
    }

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureBefore(value={DefaultAuthorizationAutoConfiguration.class})
    static class ReactiveAuthorizationServiceAutoConfiguration {
        ReactiveAuthorizationServiceAutoConfiguration() {
        }

        @ConditionalOnBean(value={ReactiveRepository.class})
        @Bean
        public ReactiveUserService reactiveUserService() {
            return new DefaultReactiveUserService();
        }

        @Bean
        @ConditionalOnBean(value={ReactiveUserService.class})
        public ReactiveAuthenticationManagerProvider defaultReactiveAuthenticationManager() {
            return new DefaultReactiveAuthenticationManager();
        }

        @Bean
        @ConditionalOnBean(value={ReactiveUserService.class})
        public ReactiveAuthenticationInitializeService reactiveAuthenticationInitializeService() {
            return new DefaultReactiveAuthenticationInitializeService();
        }

        @Bean
        public PermissionSynchronization permissionSynchronization(ReactiveRepository<PermissionEntity, String> permissionRepository, ObjectProvider<AuthorizeDefinitionCustomizer> customizer) {
            return new PermissionSynchronization(permissionRepository, (AuthorizeDefinitionCustomizer)new CompositeAuthorizeDefinitionCustomizer(customizer));
        }

        @Bean
        public DefaultDimensionService defaultDimensionService() {
            return new DefaultDimensionService();
        }

        @Bean
        public DefaultDimensionUserService defaultDimensionUserService() {
            return new DefaultDimensionUserService();
        }

        @Bean
        public DefaultAuthorizationSettingService defaultAuthorizationSettingService() {
            return new DefaultAuthorizationSettingService();
        }

        @Bean
        public DefaultPermissionService defaultPermissionService() {
            return new DefaultPermissionService();
        }

        @Bean
        @ConditionalOnBean(value={UserTokenManager.class})
        public RemoveUserTokenWhenUserDisabled removeUserTokenWhenUserDisabled(UserTokenManager tokenManager) {
            return new RemoveUserTokenWhenUserDisabled(tokenManager);
        }
    }
}

