/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.webflux;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.User;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.DeleteAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceQueryController;
import org.hswebframework.web.system.authorization.api.entity.UserEntity;
import org.hswebframework.web.system.authorization.defaults.service.DefaultReactiveUserService;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/user"})
@Authorize
@Resource(id="user", name="\u7cfb\u7edf\u7528\u6237", group={"system"})
@Tag(name="\u7528\u6237\u7ba1\u7406")
public class WebFluxUserController
implements ReactiveServiceQueryController<UserEntity, String> {
    @Autowired
    private DefaultReactiveUserService reactiveUserService;

    @PatchMapping
    @SaveAction
    @Operation(summary="\u4fdd\u5b58\u7528\u6237\u4fe1\u606f")
    public Mono<Boolean> saveUser(@RequestBody Mono<UserEntity> user) {
        return (Mono)Authentication.currentReactive().zipWith(user, (u, e) -> {
            e.setCreateTimeNow();
            e.setCreatorId(u.getUser().getId());
            return e;
        }).switchIfEmpty(user).as(this.reactiveUserService::saveUser);
    }

    @PutMapping(value={"/me"})
    @Operation(summary="\u4fee\u6539\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    @ResourceAction(id="update-self-info", name="\u4fee\u6539\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    public Mono<Boolean> updateLoginUserInfo(@RequestBody UserEntity request) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).map(Authentication::getUser).map(User::getId).flatMap(userId -> this.reactiveUserService.updateById(userId, Mono.just((Object)request)).map(integer -> integer > 0));
    }

    @PutMapping(value={"/{id:.+}/{state}"})
    @SaveAction
    @Operation(summary="\u4fee\u6539\u7528\u6237\u72b6\u6001")
    public Mono<Integer> changeState(@PathVariable @Parameter(description="\u7528\u6237ID") String id, @PathVariable @Parameter(description="\u72b6\u6001,0\u7981\u7528,1\u542f\u7528") Byte state) {
        return this.reactiveUserService.changeState((Publisher<String>)Mono.just((Object)id), state);
    }

    @DeleteMapping(value={"/{id:.+}"})
    @DeleteAction
    @Operation(summary="\u5220\u9664\u7528\u6237")
    public Mono<Boolean> deleteUser(@PathVariable String id) {
        return this.reactiveUserService.deleteUser(id);
    }

    @PutMapping(value={"/passwd"})
    @ResourceAction(id="update-self-pwd", name="\u4fee\u6539\u5f53\u524d\u7528\u6237\u5bc6\u7801")
    @Operation(summary="\u4fee\u6539\u5f53\u524d\u7528\u6237\u5bc6\u7801")
    public Mono<Boolean> changePassword(@RequestBody ChangePasswordRequest request) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).map(Authentication::getUser).map(User::getId).flatMap(userId -> this.reactiveUserService.changePassword((String)userId, request.getOldPassword(), request.getNewPassword()));
    }

    public DefaultReactiveUserService getService() {
        return this.reactiveUserService;
    }

    public static class ChangePasswordRequest {
        private String oldPassword;
        private String newPassword;

        public String getOldPassword() {
            return this.oldPassword;
        }

        public String getNewPassword() {
            return this.newPassword;
        }

        public void setOldPassword(String oldPassword) {
            this.oldPassword = oldPassword;
        }

        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }
    }
}

