/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.web.crud.events.EntityCreatedEvent;
import org.hswebframework.web.crud.events.EntityDeletedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.event.AsyncEvent;
import org.hswebframework.web.system.authorization.api.entity.DimensionEntity;
import org.hswebframework.web.system.authorization.api.entity.DimensionUserEntity;
import org.hswebframework.web.system.authorization.api.event.ClearUserAuthorizationCacheEvent;
import org.hswebframework.web.system.authorization.api.event.DimensionBindEvent;
import org.hswebframework.web.system.authorization.api.event.DimensionUnbindEvent;
import org.hswebframework.web.system.authorization.api.event.UserDeletedEvent;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.Function3;

public class DefaultDimensionUserService
extends GenericReactiveCrudService<DimensionUserEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(DefaultDimensionUserService.class);
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    @EventListener
    public void handleUserDeleteEntity(UserDeletedEvent event) {
        event.async((Publisher)((ReactiveDelete)this.createDelete().where(DimensionUserEntity::getUserId, (Object)event.getUser().getId())).execute().doOnSuccess(i -> log.debug("user deleted,clear user dimension!")));
    }

    @EventListener
    public void dispatchDimensionBind(EntitySavedEvent<DimensionUserEntity> event) {
        event.async((Publisher)this.publishEvent((Publisher<DimensionUserEntity>)Flux.fromIterable((Iterable)event.getEntity()), (Function3<String, String, List<String>, AsyncEvent>)((Function3)DimensionBindEvent::new)).then(this.clearUserCache(event.getEntity())));
    }

    @EventListener
    public void dispatchDimensionBind(EntityCreatedEvent<DimensionUserEntity> event) {
        event.async((Publisher)this.publishEvent((Publisher<DimensionUserEntity>)Flux.fromIterable((Iterable)event.getEntity()), (Function3<String, String, List<String>, AsyncEvent>)((Function3)DimensionBindEvent::new)).then(this.clearUserCache(event.getEntity())));
    }

    @EventListener
    public void dispatchDimensionUnbind(EntityDeletedEvent<DimensionUserEntity> event) {
        event.async((Publisher)this.publishEvent((Publisher<DimensionUserEntity>)Flux.fromIterable((Iterable)event.getEntity()), (Function3<String, String, List<String>, AsyncEvent>)((Function3)DimensionUnbindEvent::new)).then(this.clearUserCache(event.getEntity())));
    }

    @EventListener
    public void handleModifyEvent(EntityModifyEvent<DimensionUserEntity> event) {
        event.async(this.clearUserCache(event.getAfter()));
    }

    @EventListener
    public void handleDimensionDeletedEntity(EntityDeletedEvent<DimensionEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).collect(Collectors.groupingBy(DimensionEntity::getTypeId, Collectors.mapping(DimensionEntity::getId, Collectors.toSet()))).flatMapIterable(Map::entrySet).flatMap(entry -> ((ReactiveDelete)((ReactiveDelete)this.createDelete().where(DimensionUserEntity::getDimensionTypeId, entry.getKey())).in(DimensionUserEntity::getDimensionId, (Collection)entry.getValue())).execute()));
    }

    private Flux<DimensionUserEntity> publishEvent(Publisher<DimensionUserEntity> stream, Function3<String, String, List<String>, AsyncEvent> event) {
        Flux cache = Flux.from(stream).doOnNext(DimensionUserEntity::generateId).cache();
        return cache.groupBy(DimensionUserEntity::getDimensionTypeId).flatMap(typeGroup -> {
            String type = (String)typeGroup.key();
            return typeGroup.groupBy(DimensionUserEntity::getDimensionId).flatMap(dimensionIdGroup -> {
                String dimensionId = (String)dimensionIdGroup.key();
                return dimensionIdGroup.map(DimensionUserEntity::getUserId).collectList().flatMap(userIdList -> {
                    this.eventPublisher.publishEvent((Object)ClearUserAuthorizationCacheEvent.of((Collection)userIdList));
                    return ((AsyncEvent)event.apply((Object)type, (Object)dimensionId, userIdList)).publish(this.eventPublisher);
                });
            });
        }).thenMany((Publisher)cache);
    }

    private Mono<Void> clearUserCache(List<DimensionUserEntity> entities) {
        return Flux.fromIterable(entities).map(DimensionUserEntity::getUserId).distinct().collectList().map(ClearUserAuthorizationCacheEvent::of).doOnNext(arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0)).then();
    }
}

