/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationRequest;
import org.hswebframework.web.authorization.ReactiveAuthenticationInitializeService;
import org.hswebframework.web.authorization.ReactiveAuthenticationManagerProvider;
import org.hswebframework.web.authorization.simple.PlainTextUsernamePasswordAuthenticationRequest;
import org.hswebframework.web.cache.ReactiveCacheManager;
import org.hswebframework.web.system.authorization.api.entity.UserEntity;
import org.hswebframework.web.system.authorization.api.event.ClearUserAuthorizationCacheEvent;
import org.hswebframework.web.system.authorization.api.service.reactive.ReactiveUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import reactor.core.publisher.Mono;

@Order(value=100)
public class DefaultReactiveAuthenticationManager
implements ReactiveAuthenticationManagerProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultReactiveAuthenticationManager.class);
    @Autowired
    private ReactiveUserService reactiveUserService;
    @Autowired
    private ReactiveAuthenticationInitializeService initializeService;
    @Autowired(required=false)
    private ReactiveCacheManager cacheManager;

    @EventListener
    public void handleClearAuthCache(ClearUserAuthorizationCacheEvent event) {
        if (this.cacheManager != null) {
            if (event.isAll()) {
                this.cacheManager.getCache("user-auth").clear().doOnSuccess(nil -> log.info("clear all user authentication cache success")).doOnError(err -> log.error(err.getMessage(), err)).subscribe();
            } else {
                this.cacheManager.getCache("user-auth").evictAll((Iterable)event.getUserId()).doOnError(err -> log.error(err.getMessage(), err)).doOnSuccess(__ -> log.info("clear user {} authentication cache success", (Object)event.getUserId())).subscribe();
            }
        }
    }

    public Mono<Authentication> authenticate(Mono<AuthenticationRequest> request) {
        return request.filter(PlainTextUsernamePasswordAuthenticationRequest.class::isInstance).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u7c7b\u578b"))).map(PlainTextUsernamePasswordAuthenticationRequest.class::cast).flatMap(pwdRequest -> this.reactiveUserService.findByUsernameAndPassword(pwdRequest.getUsername(), pwdRequest.getPassword())).filter(user -> Byte.valueOf((byte)1).equals(user.getStatus())).map(UserEntity::getId).flatMap(this::getByUserId);
    }

    public Mono<Authentication> getByUserId(String userId) {
        return Mono.justOrEmpty((Object)userId).flatMap(_id -> Mono.justOrEmpty((Object)this.cacheManager).map(cm -> this.cacheManager.getCache("user-auth")).flatMap(cache -> cache.mono((Object)userId).onCacheMissResume(() -> this.initializeService.initUserAuthorization(userId))).cast(Authentication.class));
    }
}

