/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.webflux;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.api.crud.entity.QueryNoPagingOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.system.authorization.api.entity.PermissionEntity;
import org.hswebframework.web.system.authorization.defaults.configuration.PermissionProperties;
import org.hswebframework.web.system.authorization.defaults.service.DefaultPermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/permission"})
@Authorize
@Resource(id="permission", name="\u6743\u9650\u7ba1\u7406", group={"system"})
@Tag(name="\u6743\u9650\u7ba1\u7406")
public class WebFluxPermissionController
implements ReactiveServiceCrudController<PermissionEntity, String> {
    @Autowired
    private DefaultPermissionService permissionService;
    @Autowired
    private PermissionProperties permissionProperties;

    public ReactiveCrudService<PermissionEntity, String> getService() {
        return this.permissionService;
    }

    @PutMapping(value={"/status/{status}"})
    @SaveAction
    @Operation(summary="\u6279\u91cf\u4fee\u6539\u6743\u9650\u72b6\u6001")
    public Mono<Integer> changePermissionState(@PathVariable @Parameter(description="\u72b6\u6001\u503c:0\u7981\u7528,1\u542f\u7528.") Byte status, @RequestBody List<String> idList) {
        return Mono.just(idList).filter(CollectionUtils::isNotEmpty).flatMap(list -> ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.permissionService.createUpdate().set(PermissionEntity::getStatus, (Object)status)).where()).in(PermissionEntity::getId, (Collection)list)).execute()).defaultIfEmpty((Object)0);
    }

    @GetMapping(value={"/_query/for-grant"})
    @ResourceAction(id="grant", name="\u8d4b\u6743")
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u7528\u4e8e\u8d4b\u6743\u7684\u6743\u9650\u5217\u8868")
    public Flux<PermissionEntity> queryForGrant(QueryParamEntity query) {
        return Authentication.currentReactive().flatMapMany(auth -> this.permissionProperties.getFilter().doFilter((Flux<PermissionEntity>)this.permissionService.query(query.noPaging()), (Authentication)auth));
    }
}

