/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.service;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Column;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.utils.ClassUtils;
import org.hswebframework.web.api.crud.entity.Entity;
import org.hswebframework.web.authorization.define.AopAuthorizeDefinition;
import org.hswebframework.web.authorization.define.AuthorizeDefinition;
import org.hswebframework.web.authorization.define.AuthorizeDefinitionInitializedEvent;
import org.hswebframework.web.authorization.define.DataAccessTypeDefinition;
import org.hswebframework.web.authorization.define.MergedAuthorizeDefinition;
import org.hswebframework.web.authorization.define.ResourceActionDefinition;
import org.hswebframework.web.authorization.define.ResourceDefinition;
import org.hswebframework.web.crud.web.reactive.ReactiveQueryController;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceQueryController;
import org.hswebframework.web.system.authorization.api.entity.ActionEntity;
import org.hswebframework.web.system.authorization.api.entity.OptionalField;
import org.hswebframework.web.system.authorization.api.entity.PermissionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.event.EventListener;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PermissionSynchronization
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(PermissionSynchronization.class);
    @Autowired
    private ReactiveRepository<PermissionEntity, String> permissionRepository;
    private final MergedAuthorizeDefinition definition = new MergedAuthorizeDefinition();
    private final Map<String, List<OptionalField>> entityFieldsMapping = new HashMap<String, List<OptionalField>>();

    @EventListener
    public void handleResourceParseEvent(AuthorizeDefinitionInitializedEvent event) {
        this.definition.merge(event.getAllDefinition());
        for (AuthorizeDefinition authorizeDefinition : event.getAllDefinition()) {
            Class entity;
            Class target;
            if (authorizeDefinition.getResources().getResources().isEmpty()) continue;
            String id = ((ResourceDefinition)authorizeDefinition.getResources().getResources().iterator().next()).getId();
            if (this.entityFieldsMapping.containsKey(id)) {
                return;
            }
            if (!(authorizeDefinition instanceof AopAuthorizeDefinition) || !ReactiveQueryController.class.isAssignableFrom(target = ((AopAuthorizeDefinition)authorizeDefinition).getTargetClass()) && !ReactiveServiceQueryController.class.isAssignableFrom(target) || !Entity.class.isAssignableFrom(entity = ClassUtils.getGenericType((Class)target))) continue;
            HashSet fields = new HashSet();
            ReflectionUtils.doWithFields((Class)entity, field -> {
                if (null != field.getAnnotation(Column.class) && !"id".equals(field.getName())) {
                    OptionalField optionalField = new OptionalField();
                    optionalField.setName(field.getName());
                    Optional.ofNullable(field.getAnnotation(Schema.class)).map(Schema::description).ifPresent(arg_0 -> ((OptionalField)optionalField).setDescribe(arg_0));
                    fields.add(optionalField);
                }
            });
            this.entityFieldsMapping.put(id, new ArrayList(fields));
        }
    }

    protected PermissionEntity convert(Map<String, PermissionEntity> old, ResourceDefinition definition) {
        PermissionEntity entity = old.getOrDefault(definition.getId(), PermissionEntity.builder().name(definition.getName()).describe(definition.getDescription()).status(Byte.valueOf((byte)1)).build());
        entity.setId((Object)definition.getId());
        if (CollectionUtils.isEmpty((Collection)entity.getOptionalFields())) {
            entity.setOptionalFields(this.entityFieldsMapping.get(entity.getId()));
        }
        HashMap<String, ActionEntity> oldAction = new HashMap<String, ActionEntity>();
        if (entity.getActions() != null) {
            entity.getActions().forEach(a -> oldAction.put(a.getAction(), (ActionEntity)a));
        }
        for (ResourceActionDefinition definitionAction : definition.getActions()) {
            ActionEntity action = oldAction.getOrDefault(definitionAction.getId(), ActionEntity.builder().action(definitionAction.getId()).name(definitionAction.getName()).describe(definitionAction.getName()).build());
            Map properties = Optional.ofNullable(action.getProperties()).orElse(new HashMap());
            Set types = Optional.of(properties.computeIfAbsent("supportDataAccessTypes", t -> new HashSet())).filter(Collection.class::isInstance).map(Collection.class::cast).map(HashSet::new).orElseGet(HashSet::new);
            types.addAll(definitionAction.getDataAccess().getDataAccessTypes().stream().map(DataAccessTypeDefinition::getId).collect(Collectors.toSet()));
            action.setProperties(properties);
            oldAction.put(action.getAction(), action);
        }
        entity.setActions(new ArrayList(oldAction.values()));
        return entity;
    }

    public void run(String ... args) throws Exception {
        if (this.definition.getResources().isEmpty()) {
            return;
        }
        this.permissionRepository.createQuery().fetch().collect(Collectors.toMap(PermissionEntity::getId, Function.identity())).flatMap(group -> (Mono)Flux.fromIterable((Iterable)this.definition.getResources()).map(d -> this.convert((Map<String, PermissionEntity>)group, (ResourceDefinition)d)).as(arg_0 -> this.permissionRepository.save(arg_0))).doOnError(err -> log.warn("sync permission error", err)).subscribe(l -> log.info("sync permission success:{}", l));
    }
}

