/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.defaults.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.Permission;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.system.authorization.api.entity.AuthorizationSettingEntity;
import org.hswebframework.web.system.authorization.api.entity.PermissionEntity;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

@ConfigurationProperties(prefix="hsweb.permission")
public class PermissionProperties {
    private PermissionFilter filter = new PermissionFilter();

    public PermissionFilter getFilter() {
        return this.filter;
    }

    public void setFilter(PermissionFilter filter) {
        this.filter = filter;
    }

    public static class PermissionFilter {
        private boolean enabled = false;
        private UnAuthStrategy unAuthStrategy = UnAuthStrategy.error;
        private Set<String> excludeUsername = new HashSet<String>();

        public AuthorizationSettingEntity handleSetting(Authentication authentication, AuthorizationSettingEntity setting) {
            if (!this.enabled || this.excludeUsername.contains(authentication.getUser().getUsername())) {
                return setting;
            }
            if (authentication.hasPermission(setting.getPermission(), (Collection)setting.getActions())) {
                return setting;
            }
            return this.unAuthStrategy.handle(authentication, setting);
        }

        public Flux<PermissionEntity> doFilter(Flux<PermissionEntity> flux, Authentication authentication) {
            if (!this.enabled || this.excludeUsername.contains(authentication.getUser().getUsername())) {
                return flux;
            }
            return flux.map(entity -> entity.copy(action -> authentication.hasPermission(entity.getId(), new String[]{action.getAction()}), optionalField -> true)).filter(entity -> !CollectionUtils.isEmpty((Collection)entity.getActions()));
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public UnAuthStrategy getUnAuthStrategy() {
            return this.unAuthStrategy;
        }

        public Set<String> getExcludeUsername() {
            return this.excludeUsername;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setUnAuthStrategy(UnAuthStrategy unAuthStrategy) {
            this.unAuthStrategy = unAuthStrategy;
        }

        public void setExcludeUsername(Set<String> excludeUsername) {
            this.excludeUsername = excludeUsername;
        }

        public static enum UnAuthStrategy {
            ignore{

                @Override
                public AuthorizationSettingEntity handle(Authentication authentication, AuthorizationSettingEntity setting) {
                    return setting.copy(action -> authentication.hasPermission(setting.getPermission(), new String[]{action}), access -> true);
                }
            }
            ,
            error{

                @Override
                public AuthorizationSettingEntity handle(Authentication authentication, AuthorizationSettingEntity setting) {
                    HashSet actions = new HashSet(setting.getActions());
                    actions.removeAll(authentication.getPermission(setting.getPermission()).map(Permission::getActions).orElseGet(Collections::emptySet));
                    throw new AccessDenyException("\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650:" + setting.getPermission() + "" + actions);
                }
            };


            public abstract AuthorizationSettingEntity handle(Authentication var1, AuthorizationSettingEntity var2);
        }
    }
}

