/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.entity.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.validator.constraints.NotBlank;
import org.hswebframework.web.commons.entity.SimpleGenericEntity;
import org.hswebframework.web.entity.authorization.ActionEntity;
import org.hswebframework.web.entity.authorization.OptionalField;
import org.hswebframework.web.entity.authorization.ParentPermission;
import org.hswebframework.web.entity.authorization.PermissionEntity;

public class SimplePermissionEntity
extends SimpleGenericEntity<String>
implements PermissionEntity {
    private static final long serialVersionUID = -5505339187716888516L;
    @NotBlank
    private String name;
    private String describe;
    private Byte status;
    private String type;
    private List<String> supportDataAccessTypes;
    private List<ActionEntity> actions;
    private List<OptionalField> optionalFields;
    private List<ParentPermission> parents;

    public SimplePermissionEntity clone() {
        SimplePermissionEntity target = (SimplePermissionEntity)super.clone();
        if (this.actions != null) {
            target.setActions(this.getActions().stream().map(ActionEntity::clone).collect(Collectors.toList()));
        }
        if (this.optionalFields != null) {
            target.setOptionalFields(this.getOptionalFields().stream().map(OptionalField::clone).collect(Collectors.toList()));
        }
        if (this.supportDataAccessTypes != null) {
            target.setSupportDataAccessTypes(new ArrayList<String>(this.supportDataAccessTypes));
        }
        return target;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescribe() {
        return this.describe;
    }

    @Override
    public Byte getStatus() {
        return this.status;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<String> getSupportDataAccessTypes() {
        return this.supportDataAccessTypes;
    }

    @Override
    public List<ActionEntity> getActions() {
        return this.actions;
    }

    @Override
    public List<OptionalField> getOptionalFields() {
        return this.optionalFields;
    }

    @Override
    public List<ParentPermission> getParents() {
        return this.parents;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDescribe(String describe) {
        this.describe = describe;
    }

    @Override
    public void setStatus(Byte status) {
        this.status = status;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setSupportDataAccessTypes(List<String> supportDataAccessTypes) {
        this.supportDataAccessTypes = supportDataAccessTypes;
    }

    @Override
    public void setActions(List<ActionEntity> actions) {
        this.actions = actions;
    }

    @Override
    public void setOptionalFields(List<OptionalField> optionalFields) {
        this.optionalFields = optionalFields;
    }

    public void setParents(List<ParentPermission> parents) {
        this.parents = parents;
    }
}

