/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter;

import java.util.Collections;
import java.util.Optional;
import org.hswebframework.web.starter.CorsProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.filter.CorsFilter;

@Configuration
@ConditionalOnProperty(prefix="hsweb.cors", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={CorsProperties.class})
public class CorsAutoConfiguration {
    private static CorsConfiguration buildConfiguration(CorsProperties.CorsConfiguration config) {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowedHeaders(config.getAllowedHeaders());
        corsConfiguration.setAllowedMethods(config.getAllowedMethods());
        corsConfiguration.setAllowedOrigins(config.getAllowedOrigins());
        corsConfiguration.setAllowCredentials(config.getAllowCredentials());
        corsConfiguration.setExposedHeaders(config.getExposedHeaders());
        corsConfiguration.setMaxAge(config.getMaxAge());
        return corsConfiguration;
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class WebFluxCorsConfiguration {
        WebFluxCorsConfiguration() {
        }

        @Bean
        public CorsWebFilter webFluxCorsRegistration(CorsProperties corsProperties) {
            org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource corsConfigurationSource = new org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource();
            Optional.ofNullable(corsProperties.getConfigs()).orElseGet(() -> Collections.singletonList(new CorsProperties.CorsConfiguration().applyPermitDefaultValues())).forEach(config -> corsConfigurationSource.registerCorsConfiguration(config.getPath(), CorsAutoConfiguration.buildConfiguration(config)));
            return new CorsWebFilter((CorsConfigurationSource)corsConfigurationSource);
        }
    }

    @ConditionalOnClass(name={"javax.servlet.Filter"})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Configuration
    static class WebMvcCorsConfiguration {
        WebMvcCorsConfiguration() {
        }

        @Bean
        public CorsFilter corsFilter(CorsProperties corsProperties) {
            UrlBasedCorsConfigurationSource corsConfigurationSource = new UrlBasedCorsConfigurationSource();
            Optional.ofNullable(corsProperties.getConfigs()).orElseGet(() -> Collections.singletonList(new CorsProperties.CorsConfiguration().applyPermitDefaultValues())).forEach(config -> corsConfigurationSource.registerCorsConfiguration(config.getPath(), CorsAutoConfiguration.buildConfiguration(config)));
            return new CorsFilter((org.springframework.web.cors.CorsConfigurationSource)corsConfigurationSource);
        }
    }
}

