/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.hswebframework.web.api.crud.entity.EntityFactory;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.starter.jackson.Jackson2Tokenizer;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.codec.HttpMessageDecoder;
import org.springframework.http.codec.json.Jackson2CodecSupport;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CustomJackson2JsonDecoder
extends Jackson2CodecSupport
implements HttpMessageDecoder<Object> {
    private final EntityFactory entityFactory;

    public CustomJackson2JsonDecoder(EntityFactory entityFactory, ObjectMapper mapper, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
        this.entityFactory = entityFactory;
    }

    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Type type = elementType.resolve() == null ? elementType.getType() : elementType.resolve();
        JavaType javaType = this.getObjectMapper().getTypeFactory().constructType(type);
        return !CharSequence.class.isAssignableFrom(elementType.toClass()) && this.getObjectMapper().canDeserialize(javaType) && this.supportsMimeType(mimeType);
    }

    @NonNull
    public Flux<Object> decode(@NonNull Publisher<DataBuffer> input, @NonNull ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        ObjectMapper mapper = this.getObjectMapper();
        Flux<TokenBuffer> tokens = Jackson2Tokenizer.tokenize((Flux<DataBuffer>)Flux.from(input), mapper.getFactory(), mapper, true);
        ObjectReader reader = this.getObjectReader(elementType, hints);
        return ((Flux)tokens.as(LocaleUtils::transform)).handle((tokenBuffer, sink) -> {
            try {
                Object value = reader.readValue(tokenBuffer.asParser((ObjectCodec)this.getObjectMapper()));
                this.logValue(value, hints);
                if (value != null) {
                    sink.next(value);
                }
            }
            catch (IOException ex) {
                sink.error((Throwable)this.processException(ex));
            }
        });
    }

    @NonNull
    public Mono<Object> decodeToMono(@NonNull Publisher<DataBuffer> input, @NonNull ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return ((Mono)DataBufferUtils.join(input).as(LocaleUtils::transform)).map(dataBuffer -> this.decode((DataBuffer)dataBuffer, elementType, mimeType, hints));
    }

    @NonNull
    public Object decode(@NonNull DataBuffer dataBuffer, @NonNull ResolvableType targetType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) throws DecodingException {
        try {
            ObjectReader objectReader = this.getObjectReader(targetType, hints);
            Object value = objectReader.readValue(dataBuffer.asInputStream());
            this.logValue(value, hints);
            Object object = value;
            return object;
        }
        catch (IOException ex) {
            throw this.processException(ex);
        }
        finally {
            DataBufferUtils.release((DataBuffer)dataBuffer);
        }
    }

    private Type getRelType(Type type) {
        Class realType;
        if (type instanceof Class && (realType = this.entityFactory.getInstanceType((Class)type, false)) != null) {
            return realType;
        }
        if (type instanceof ParameterizedType) {
            ResolvableType elementType = ResolvableType.forType((Type)type);
            ResolvableType[] generics = elementType.getGenerics();
            for (int i = 0; i < generics.length; ++i) {
                generics[i] = ResolvableType.forType((Type)this.getRelType(generics[i].getType()));
            }
            type = ResolvableType.forClassWithGenerics((Class)elementType.toClass(), (ResolvableType[])generics).getType();
        }
        return type;
    }

    private ObjectReader getObjectReader(ResolvableType elementType, @Nullable Map<String, Object> hints) {
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        MethodParameter param = this.getParameter(elementType);
        Class contextClass = param != null ? param.getContainingClass() : null;
        Type type = elementType.resolve() == null ? elementType.getType() : elementType.toClass();
        type = elementType.getType() instanceof ParameterizedType ? this.getRelType(elementType.getType()) : this.getRelType(type);
        JavaType javaType = this.getJavaType(type, contextClass);
        Class jsonView = hints != null ? (Class)hints.get(Jackson2CodecSupport.JSON_VIEW_HINT) : null;
        return jsonView != null ? this.getObjectMapper().readerWithView(jsonView).forType(javaType) : this.getObjectMapper().readerFor(javaType);
    }

    private void logValue(@Nullable Object value, @Nullable Map<String, Object> hints) {
        if (!Hints.isLoggingSuppressed(hints)) {
            LogFormatUtils.traceDebug((Log)this.logger, traceOn -> {
                String formatted = LogFormatUtils.formatValue((Object)value, (traceOn == false ? 1 : 0) != 0);
                return Hints.getLogPrefix((Map)hints) + "Decoded [" + formatted + "]";
            });
        }
    }

    private CodecException processException(IOException ex) {
        if (ex instanceof InvalidDefinitionException) {
            JavaType type = ((InvalidDefinitionException)ex).getType();
            return new CodecException("Type definition error: " + type, (Throwable)ex);
        }
        if (ex instanceof JsonProcessingException) {
            String originalMessage = ((JsonProcessingException)ex).getOriginalMessage();
            return new DecodingException("JSON decoding error: " + originalMessage, (Throwable)ex);
        }
        return new DecodingException("I/O error while parsing input stream", (Throwable)ex);
    }

    @NonNull
    public Map<String, Object> getDecodeHints(@NonNull ResolvableType actualType, @NonNull ResolvableType elementType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        return this.getHints(actualType);
    }

    @NonNull
    public List<MimeType> getDecodableMimeTypes() {
        return this.getMimeTypes();
    }

    protected <A extends Annotation> A getAnnotation(MethodParameter parameter, @NonNull Class<A> annotType) {
        return (A)parameter.getParameterAnnotation(annotType);
    }
}

