/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ClassStack;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.fasterxml.jackson.databind.type.TypeParser;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.LRUMap;
import org.hswebframework.web.api.crud.entity.EntityFactory;

public class CustomTypeFactory
extends TypeFactory {
    private EntityFactory entityFactory;

    public CustomTypeFactory(EntityFactory factory) {
        super(new LRUMap(64, 1024));
        this.entityFactory = factory;
    }

    protected CustomTypeFactory(LRUMap<Object, JavaType> typeCache, TypeParser p, TypeModifier[] mods, ClassLoader classLoader) {
        super(typeCache, p, mods, classLoader);
    }

    public TypeFactory withCache(LRUMap<Object, JavaType> cache) {
        return new CustomTypeFactory(cache, this._parser, this._modifiers, this._classLoader);
    }

    public TypeFactory withClassLoader(ClassLoader classLoader) {
        return new CustomTypeFactory((LRUMap<Object, JavaType>)this._typeCache, this._parser, this._modifiers, this._classLoader);
    }

    public TypeFactory withModifier(TypeModifier mod) {
        TypeModifier[] mods;
        LRUMap typeCache = this._typeCache;
        if (mod == null) {
            mods = null;
            typeCache = null;
        } else if (this._modifiers == null) {
            mods = new TypeModifier[]{mod};
            typeCache = null;
        } else {
            mods = (TypeModifier[])ArrayBuilders.insertInListNoDup((Object[])this._modifiers, (Object)mod);
        }
        return new CustomTypeFactory((LRUMap<Object, JavaType>)typeCache, this._parser, mods, this._classLoader);
    }

    protected JavaType _fromWellKnownInterface(ClassStack context, Class<?> rawType, TypeBindings bindings, JavaType superClass, JavaType[] superInterfaces) {
        JavaType javaType = super._fromWellKnownInterface(context, rawType, bindings, superClass, superInterfaces);
        if (javaType == null && (rawType = this.entityFactory.getInstanceType(rawType)) != null) {
            javaType = SimpleType.constructUnsafe((Class)rawType);
        }
        return javaType;
    }

    protected JavaType _fromWellKnownClass(ClassStack context, Class<?> rawType, TypeBindings bindings, JavaType superClass, JavaType[] superInterfaces) {
        JavaType javaType = super._fromWellKnownClass(context, rawType, bindings, superClass, superInterfaces);
        if (javaType == null && (rawType = this.entityFactory.getInstanceType(rawType)) != null) {
            javaType = SimpleType.constructUnsafe((Class)rawType);
        }
        return javaType;
    }
}

