/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.hswebframework.web.api.crud.entity.EntityFactory;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.starter.jackson.CustomJackson2JsonDecoder;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.Decoder;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.util.MimeType;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class CustomCodecsAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    static class JacksonDecoderConfiguration {
        JacksonDecoderConfiguration() {
        }

        @Bean
        @Order(value=1)
        @ConditionalOnBean(value={ObjectMapper.class})
        CodecCustomizer jacksonDecoderCustomizer(EntityFactory entityFactory, ObjectMapper objectMapper) {
            SimpleModule module = new SimpleModule();
            EnumDict.EnumDictJSONDeserializer deserializer = new EnumDict.EnumDictJSONDeserializer();
            module.addDeserializer(Enum.class, (JsonDeserializer)deserializer);
            objectMapper.registerModule((Module)module);
            return configurer -> {
                CodecConfigurer.DefaultCodecs defaults = configurer.defaultCodecs();
                defaults.jackson2JsonDecoder((Decoder)new CustomJackson2JsonDecoder(objectMapper, new MimeType[0]));
            };
        }
    }
}

