/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.resolver;

import org.hswebframework.web.starter.convert.FastJsonGenericHttpMessageConverter;
import org.hswebframework.web.starter.resolver.JsonParam;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class JsonParamResolver
implements HandlerMethodArgumentResolver {
    private FastJsonGenericHttpMessageConverter fastJsonHttpMessageConverter;

    public JsonParamResolver(FastJsonGenericHttpMessageConverter fastJsonHttpMessageConverter) {
        this.fastJsonHttpMessageConverter = fastJsonHttpMessageConverter;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(JsonParam.class) && this.fastJsonHttpMessageConverter != null;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        JsonParam jsonParam = (JsonParam)parameter.getParameterAnnotation(JsonParam.class);
        String object = webRequest.getParameter(jsonParam.value());
        if (null != object) {
            Class type = jsonParam.type() != Void.class ? jsonParam.type() : parameter.getParameterType();
            return this.fastJsonHttpMessageConverter.readByString(type, object);
        }
        return null;
    }
}

