/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.init;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.ezorm.core.ObjectWrapper;
import org.hswebframework.ezorm.core.Query;
import org.hswebframework.ezorm.core.Update;
import org.hswebframework.ezorm.core.ValueConverter;
import org.hswebframework.ezorm.rdb.RDBDatabase;
import org.hswebframework.ezorm.rdb.RDBTable;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.converter.ClobValueConverter;
import org.hswebframework.ezorm.rdb.meta.converter.JSONValueConverter;
import org.hswebframework.ezorm.rdb.meta.converter.NumberValueConverter;
import org.hswebframework.ezorm.rdb.simple.wrapper.BeanWrapper;
import org.hswebframework.web.starter.SystemVersion;
import org.hswebframework.web.starter.init.SkipCreateOrAlterRDBDatabase;
import org.hswebframework.web.starter.init.simple.SimpleDependencyInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;

public class SystemInitialize {
    private Logger logger = LoggerFactory.getLogger(SystemInitialize.class);
    private SqlExecutor sqlExecutor;
    private RDBDatabase database;
    private SystemVersion targetVersion;
    private SystemVersion installed;
    private List<SimpleDependencyInstaller> readyToInstall;
    private List<String> excludeTables;
    private String installScriptPath = "classpath*:hsweb-starter.js";
    private Map<String, Object> scriptContext = new HashMap<String, Object>();
    private boolean initialized = false;

    public SystemInitialize(SqlExecutor sqlExecutor, RDBDatabase database, SystemVersion targetVersion) {
        this.sqlExecutor = sqlExecutor;
        this.database = database;
        this.targetVersion = targetVersion;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        if (!CollectionUtils.isEmpty(this.excludeTables)) {
            this.database = new SkipCreateOrAlterRDBDatabase(this.database, this.excludeTables, this.sqlExecutor);
        }
        this.scriptContext.put("sqlExecutor", this.sqlExecutor);
        this.scriptContext.put("database", this.database);
        this.scriptContext.put("logger", this.logger);
        this.initialized = true;
    }

    public void addScriptContext(String var, Object val) {
        this.scriptContext.put(var, val);
    }

    protected void syncSystemVersion() throws SQLException {
        RDBTable rdbTable = this.database.getTable("s_system");
        if (this.installed == null) {
            rdbTable.createInsert().value((Object)this.targetVersion).exec();
        } else {
            for (SystemVersion.Dependency dependency : this.installed.getDependencies()) {
                SystemVersion.Dependency target = this.targetVersion.getDependency(dependency.getGroupId(), dependency.getArtifactId());
                if (target != null) continue;
                this.targetVersion.getDependencies().add(dependency);
            }
            ((Update)((Update)rdbTable.createUpdate().set((Object)this.targetVersion).where()).is("name", (Object)this.targetVersion.getName())).exec();
        }
    }

    protected Map<String, Object> getScriptContext() {
        return new HashMap<String, Object>(this.scriptContext);
    }

    protected void doInstall() {
        ArrayList doInitializeDep = new ArrayList();
        List<SystemVersion.Dependency> installedDependencies = this.readyToInstall.stream().map(installer -> {
            SystemVersion.Dependency dependency = installer.getDependency();
            SystemVersion.Dependency installed = this.getInstalledDependency(dependency.getGroupId(), dependency.getArtifactId());
            if (installed == null) {
                doInitializeDep.add(installer);
                installer.doInstall(this.getScriptContext());
            }
            if (installed == null || installed.compareTo(dependency) < 0) {
                installer.doUpgrade(this.getScriptContext(), installed);
            }
            return dependency;
        }).collect(Collectors.toList());
        for (SimpleDependencyInstaller installer2 : doInitializeDep) {
            installer2.doInitialize(this.getScriptContext());
        }
        this.targetVersion.setDependencies(installedDependencies);
    }

    private SystemVersion.Dependency getInstalledDependency(String groupId, String artifactId) {
        if (this.installed == null) {
            return null;
        }
        return this.installed.getDependency(groupId, artifactId);
    }

    private SimpleDependencyInstaller getReadyToInstallDependency(String groupId, String artifactId) {
        if (this.readyToInstall == null) {
            return null;
        }
        return this.readyToInstall.stream().filter(installer -> installer.getDependency().isSameDependency(groupId, artifactId)).findFirst().orElse(null);
    }

    private void initReadyToInstallDependencies() {
        DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)"js");
        try {
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources(this.installScriptPath);
            ArrayList<SimpleDependencyInstaller> installers = new ArrayList<SimpleDependencyInstaller>();
            for (Resource resource : resources) {
                String script = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)Charset.forName("utf-8"));
                SimpleDependencyInstaller installer = new SimpleDependencyInstaller();
                engine.compile("__tmp", script);
                Map<String, Object> context = this.getScriptContext();
                context.put("dependency", installer);
                engine.execute("__tmp", context).getIfSuccess();
                installers.add(installer);
            }
            this.readyToInstall = installers;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            engine.remove("__tmp");
        }
    }

    protected void initInstallInfo() throws SQLException {
        boolean tableInstall = this.sqlExecutor.tableExists("s_system");
        this.database.createOrAlter("s_system").addColumn().name("name").varchar(128).comment("\u7cfb\u7edf\u540d\u79f0").commit().addColumn().name("major_version").alias("majorVersion").number(32).javaType(Integer.class).comment("\u4e3b\u7248\u672c\u53f7").commit().addColumn().name("minor_version").alias("minorVersion").number(32).javaType(Integer.class).comment("\u6b21\u7248\u672c\u53f7").commit().addColumn().name("revision_version").alias("revisionVersion").number(32).javaType(Integer.class).comment("\u4fee\u8ba2\u7248").commit().addColumn().name("snapshot").number(1).javaType(Boolean.class).custom(column -> column.setValueConverter((ValueConverter)new NumberValueConverter(Boolean.class))).comment("\u662f\u5426\u5feb\u7167\u7248").commit().addColumn().name("comment").varchar(2000).comment("\u7cfb\u7edf\u8bf4\u660e").commit().addColumn().name("website").varchar(2000).comment("\u7cfb\u7edf\u7f51\u5740").commit().addColumn().name("framework_version").notNull().alias("frameworkVersion").clob().custom(column -> column.setValueConverter((ValueConverter)new JSONValueConverter(SystemVersion.FrameworkVersion.class, (ValueConverter)new ClobValueConverter()))).notNull().comment("\u6846\u67b6\u7248\u672c").commit().addColumn().name("dependencies").notNull().alias("dependencies").clob().custom(column -> column.setValueConverter((ValueConverter)new JSONValueConverter(SystemVersion.Dependency.class, (ValueConverter)new ClobValueConverter()))).notNull().comment("\u4f9d\u8d56\u8be6\u60c5").commit().comment("\u7cfb\u7edf\u4fe1\u606f").custom(table -> table.setObjectWrapper((ObjectWrapper)new BeanWrapper(SystemVersion::new, table))).commit();
        if (!tableInstall) {
            this.installed = null;
            return;
        }
        RDBTable rdbTable = this.database.getTable("s_system");
        this.installed = (SystemVersion)((Query)rdbTable.createQuery().where("name", (Object)this.targetVersion.getName())).single();
    }

    public void install() throws Exception {
        this.init();
        this.initInstallInfo();
        this.initReadyToInstallDependencies();
        this.doInstall();
        this.syncSystemVersion();
    }

    public void setExcludeTables(List<String> excludeTables) {
        this.excludeTables = excludeTables;
    }

    public List<String> getExcludeTables() {
        return this.excludeTables;
    }
}

