/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpMethod;

@ConfigurationProperties(prefix="hsweb.cors")
public class CorsProperties {
    private List<Map<String, CorsConfiguration>> configs;

    public List<Map<String, CorsConfiguration>> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<Map<String, CorsConfiguration>> configs) {
        this.configs = configs;
    }

    public static class CorsConfiguration {
        public static final String ALL = "*";
        private List<String> allowedOrigins;
        private List<String> allowedMethods;
        private List<String> allowedHeaders;
        private List<String> exposedHeaders;
        private Boolean allowCredentials;
        private Long maxAge;

        CorsConfiguration applyPermitDefaultValues() {
            if (this.allowedOrigins == null) {
                this.addAllowedOrigin();
            }
            if (this.allowedMethods == null) {
                this.setAllowedMethods(Arrays.asList(HttpMethod.GET.name(), HttpMethod.HEAD.name(), HttpMethod.POST.name()));
            }
            if (this.allowedHeaders == null) {
                this.addAllowedHeader();
            }
            if (this.allowCredentials == null) {
                this.setAllowCredentials(true);
            }
            if (this.maxAge == null) {
                this.setMaxAge(1800L);
            }
            return this;
        }

        void addAllowedOrigin() {
            if (this.allowedOrigins == null) {
                this.allowedOrigins = new ArrayList<String>(4);
            }
            this.allowedOrigins.add(ALL);
        }

        void addAllowedHeader() {
            if (this.allowedHeaders == null) {
                this.allowedHeaders = new ArrayList<String>(4);
            }
            this.allowedHeaders.add(ALL);
        }

        public List<String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        public List<String> getAllowedMethods() {
            return this.allowedMethods;
        }

        public List<String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        public List<String> getExposedHeaders() {
            return this.exposedHeaders;
        }

        public Boolean getAllowCredentials() {
            return this.allowCredentials;
        }

        public Long getMaxAge() {
            return this.maxAge;
        }

        public void setAllowedOrigins(List<String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        public void setAllowedMethods(List<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        public void setAllowedHeaders(List<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
        }

        public void setExposedHeaders(List<String> exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
        }

        public void setAllowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }

        public void setMaxAge(Long maxAge) {
            this.maxAge = maxAge;
        }

        public String toString() {
            return "CorsProperties.CorsConfiguration(allowedOrigins=" + this.getAllowedOrigins() + ", allowedMethods=" + this.getAllowedMethods() + ", allowedHeaders=" + this.getAllowedHeaders() + ", exposedHeaders=" + this.getExposedHeaders() + ", allowCredentials=" + this.getAllowCredentials() + ", maxAge=" + this.getMaxAge() + ")";
        }
    }
}

