/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.convert;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.List;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.ThreadLocalUtils;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.convert.CustomMessageConverter;
import org.hswebframework.web.starter.convert.FastJsonHttpMessageConverter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class FastJsonGenericHttpMessageConverter
extends AbstractGenericHttpMessageConverter<Object>
implements Ordered {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private Charset charset = UTF8;
    private SerializerFeature[] features = new SerializerFeature[0];
    private List<CustomMessageConverter> converters;

    public FastJsonGenericHttpMessageConverter() {
        super(new MediaType[]{new MediaType("application", "json", UTF8), new MediaType("application", "*+json", UTF8)});
    }

    public void setConverters(List<CustomMessageConverter> converters) {
        this.converters = converters;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        return type instanceof ParameterizedType && super.canRead(type, contextClass, mediaType);
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.read(clazz, clazz, inputMessage);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public SerializerFeature[] getFeatures() {
        return this.features;
    }

    public void setFeatures(SerializerFeature ... features) {
        this.features = features;
    }

    public Object readByString(Type type, String jsonStr) {
        return this.readByBytes(type, jsonStr.getBytes());
    }

    public Object readByBytes(Type type, byte[] bytes) {
        if (type == String.class) {
            return new String(bytes, this.charset);
        }
        if (type instanceof Class) {
            CustomMessageConverter converter;
            Class clazz = (Class)type;
            if (null != this.converters && (converter = (CustomMessageConverter)this.converters.stream().filter(cvt -> cvt.support(clazz)).findFirst().orElse(null)) != null) {
                return converter.convert(clazz, bytes);
            }
        }
        Object object = JSON.parseObject((byte[])bytes, (int)0, (int)bytes.length, (CharsetDecoder)this.charset.newDecoder(), (Type)type, (Feature[])new Feature[0]);
        return object;
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = inputMessage.getBody();
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            if (len <= 0) continue;
            baos.write(buf, 0, len);
        }
        byte[] bytes = baos.toByteArray();
        return this.readByBytes(type, bytes);
    }

    public String converter(Object obj) {
        String text;
        if (obj instanceof String) {
            return (String)obj;
        }
        String callback = (String)ThreadLocalUtils.getAndRemove((String)"jsonp-callback");
        if (obj instanceof ResponseMessage) {
            ResponseMessage message = (ResponseMessage)obj;
            text = JSON.toJSONString((Object)obj, (SerializeFilter[])FastJsonHttpMessageConverter.parseFilter(message), (SerializerFeature[])this.features);
        } else {
            text = JSON.toJSONString((Object)obj, (SerializerFeature[])this.features);
        }
        if (!StringUtils.isNullOrEmpty((Object)callback)) {
            text = callback + "(" + text + ")";
        }
        return text;
    }

    protected void writeInternal(Object obj, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        OutputStream out = outputMessage.getBody();
        byte[] bytes = this.converter(obj).getBytes(this.charset);
        out.write(bytes);
        out.flush();
    }
}

