/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.init.simple;

import java.util.Map;
import org.hswebframework.web.starter.SystemVersion;
import org.hswebframework.web.starter.init.DependencyInstaller;
import org.hswebframework.web.starter.init.InitializeCallBack;
import org.hswebframework.web.starter.init.InstallerCallBack;
import org.hswebframework.web.starter.init.UpgradeCallBack;
import org.hswebframework.web.starter.init.simple.SimpleDependencyUpgrader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDependencyInstaller
implements DependencyInstaller {
    SystemVersion.Dependency dependency;
    InstallerCallBack installer;
    UpgradeCallBack upgrader;
    InstallerCallBack unInstaller;
    InitializeCallBack initializer;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SystemVersion.Dependency getDependency() {
        return this.dependency;
    }

    public void doInstall(Map<String, Object> context) {
        if (this.installer != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("install [{}/{}] version {} {}", new Object[]{this.dependency.getGroupId(), this.dependency.getArtifactId(), this.dependency.versionToString(), this.dependency.getWebsite()});
            }
            this.installer.execute(context);
        }
    }

    public void doInitialize(Map<String, Object> context) {
        if (this.initializer != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("initialize [{}/{}] version {} {}", new Object[]{this.dependency.getGroupId(), this.dependency.getArtifactId(), this.dependency.versionToString(), this.dependency.getWebsite()});
            }
            this.initializer.execute(context);
        }
    }

    public void doUnInstall(Map<String, Object> context) {
        if (this.unInstaller != null) {
            this.installer.execute(context);
        }
    }

    public void doUpgrade(Map<String, Object> context, SystemVersion.Dependency installed) {
        SimpleDependencyUpgrader simpleDependencyUpgrader = new SimpleDependencyUpgrader(installed, this.dependency, context);
        context.put("upgrader", simpleDependencyUpgrader);
        if (this.unInstaller != null) {
            this.upgrader.execute(context);
        }
    }

    @Override
    public DependencyInstaller setup(SystemVersion.Dependency dependency) {
        this.dependency = dependency;
        return this;
    }

    @Override
    public DependencyInstaller onInstall(InstallerCallBack callBack) {
        this.installer = callBack;
        return this;
    }

    @Override
    public DependencyInstaller onUpgrade(UpgradeCallBack callBack) {
        this.upgrader = callBack;
        return this;
    }

    @Override
    public DependencyInstaller onUninstall(InstallerCallBack callBack) {
        this.unInstaller = callBack;
        return this;
    }

    @Override
    public DependencyInstaller onInitialize(InitializeCallBack initializeCallBack) {
        this.initializer = initializeCallBack;
        return this;
    }
}

