/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.utils.MapUtils;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.factory.MapperEntityFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.ClassUtils;

@ConfigurationProperties(prefix="hsweb.entity")
public class EntityProperties {
    List<Mapping> mappings;

    public void setMappings(List<Mapping> mappings) {
        this.mappings = mappings;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    public Map<Class<Entity>, MapperEntityFactory.Mapper> createMappers() {
        if (this.mappings == null || this.mappings.isEmpty()) {
            return new HashMap<Class<Entity>, MapperEntityFactory.Mapper>();
        }
        return this.mappings.stream().map(Mapping::create).reduce(MapUtils::merge).orElseGet(HashMap::new);
    }

    public static class Mapping {
        String sourceBasePackage = "";
        String targetBasePackage = "";
        Map<String, String> mapping;

        Map<Class<Entity>, MapperEntityFactory.Mapper> create() {
            if (this.mapping == null || this.mapping.isEmpty()) {
                return new HashMap<Class<Entity>, MapperEntityFactory.Mapper>();
            }
            return this.mapping.entrySet().stream().collect(Collectors.toMap(entry -> this.getSourceClass((String)entry.getKey()), entry -> MapperEntityFactory.defaultMapper(this.getTargetClass((String)entry.getValue()))));
        }

        protected Class<Entity> getClass(String basePackage, String name) {
            if (!StringUtils.isNullOrEmpty((Object)basePackage)) {
                name = basePackage.concat(".").concat(name);
            }
            return this.classForName(name);
        }

        protected Class<Entity> getSourceClass(String name) {
            return this.getClass(this.sourceBasePackage, name);
        }

        protected Class<Entity> getTargetClass(String name) {
            Class<Entity> entityClass = this.getClass(this.targetBasePackage, name);
            if (entityClass.isInterface()) {
                throw new UnsupportedOperationException("class " + name + " is interface!");
            }
            return entityClass;
        }

        public Class<Entity> classForName(String name) {
            try {
                return ClassUtils.forName((String)name, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public String getSourceBasePackage() {
            return this.sourceBasePackage;
        }

        public void setSourceBasePackage(String sourceBasePackage) {
            this.sourceBasePackage = sourceBasePackage;
        }

        public String getTargetBasePackage() {
            return this.targetBasePackage;
        }

        public void setTargetBasePackage(String targetBasePackage) {
            this.targetBasePackage = targetBasePackage;
        }

        public Map<String, String> getMapping() {
            return this.mapping;
        }

        public void setMapping(Map<String, String> mapping) {
            this.mapping = mapping;
        }
    }
}

