/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.init.simple;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.web.starter.SystemVersion;
import org.hswebframework.web.starter.init.DependencyUpgrader;
import org.hswebframework.web.starter.init.UpgradeCallBack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDependencyUpgrader
implements DependencyUpgrader {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    SystemVersion.Dependency installed;
    SystemVersion.Dependency dependency;
    List<Map<String, Object>> shouldUpdateVersionList;
    private Map<String, Object> context;
    private boolean firstInstall;

    public SimpleDependencyUpgrader(SystemVersion.Dependency installed, SystemVersion.Dependency dependency, Map<String, Object> context) {
        this.firstInstall = installed == null;
        this.installed = this.firstInstall ? dependency : installed;
        this.context = context;
        this.dependency = dependency;
    }

    @Override
    public DependencyUpgrader filter(List<Map<String, Object>> versions) {
        this.shouldUpdateVersionList = versions.stream().filter((? super T map) -> {
            String ver = (String)map.get("version");
            if (null == ver) {
                return false;
            }
            if (this.firstInstall) {
                return true;
            }
            if (this.installed.compareTo(this.dependency) == 0) {
                return false;
            }
            return this.installed.compareTo(new SystemVersion(ver)) < 0;
        }).sorted(Comparator.comparing(m -> new SystemVersion((String)m.get("version")))).collect(Collectors.toList());
        return this;
    }

    @Override
    public void upgrade(UpgradeCallBack callBack) {
        this.shouldUpdateVersionList.forEach(context -> {
            if (this.context != null) {
                context.putAll(context);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("upgrade [{}/{}] to version:{} {}", new Object[]{this.dependency.getGroupId(), this.dependency.getArtifactId(), context.get("version"), this.dependency.getWebsite()});
            }
            callBack.execute((Map<String, Object>)context);
        });
    }
}

