/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.ezorm.rdb.RDBDatabase;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.meta.parser.H2TableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.MysqlTableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.OracleTableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.TableMetaParser;
import org.hswebframework.ezorm.rdb.render.dialect.H2RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.dialect.MysqlRDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.dialect.OracleRDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.simple.SimpleDatabase;
import org.hswebframework.web.ScriptScope;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.hswebframework.web.datasource.DatabaseType;
import org.hswebframework.web.service.Service;
import org.hswebframework.web.starter.AppProperties;
import org.hswebframework.web.starter.SystemVersion;
import org.hswebframework.web.starter.init.SystemInitialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={AppProperties.class})
@Order(value=-2147483648)
public class SystemInitializeAutoConfiguration
implements CommandLineRunner,
BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(SystemInitializeAutoConfiguration.class);
    @Autowired
    private AppProperties appProperties;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private SqlExecutor sqlExecutor;
    @Autowired
    private ApplicationContext applicationContext;
    private List<DynamicScriptEngine> engines;
    @Autowired
    private Environment environment;

    @PostConstruct
    public void init() {
        this.engines = Stream.of("js", "groovy").map(DynamicScriptEngineFactory::getEngine).filter(Objects::nonNull).collect(Collectors.toList());
        this.addGlobalVariable("logger", LoggerFactory.getLogger((String)"org.hswebframework.script"));
        this.addGlobalVariable("sqlExecutor", this.sqlExecutor);
        this.addGlobalVariable("spring", this.applicationContext);
    }

    protected void addGlobalVariable(String var, Object val) {
        this.engines.forEach(engine -> {
            try {
                engine.addGlobalVariable(Collections.singletonMap(var, val));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String ... args) throws Exception {
        OracleRDBDatabaseMetaData metaData;
        String jdbcUserName;
        if (!this.appProperties.isAutoInit()) {
            log.debug("app auto init is disabled");
            return;
        }
        DatabaseType type = DataSourceHolder.currentDatabaseType();
        SystemVersion version = this.appProperties.build();
        if (version.getName() == null) {
            version.setName("unknown");
        }
        Connection connection = null;
        try {
            connection = DataSourceHolder.currentDataSource().getNative().getConnection();
            jdbcUserName = connection.getMetaData().getUserName();
        }
        finally {
            if (null != connection) {
                connection.close();
            }
        }
        switch (type) {
            case oracle: {
                metaData = new OracleRDBDatabaseMetaData();
                metaData.setParser((TableMetaParser)new OracleTableMetaParser(this.sqlExecutor));
                break;
            }
            case mysql: {
                String engine = this.environment.getProperty("mysql.engine");
                metaData = StringUtils.hasText((String)engine) ? new MysqlRDBDatabaseMetaData(engine) : new MysqlRDBDatabaseMetaData();
                metaData.setParser((TableMetaParser)new MysqlTableMetaParser(this.sqlExecutor));
                break;
            }
            default: {
                metaData = new H2RDBDatabaseMetaData();
                metaData.setParser((TableMetaParser)new H2TableMetaParser(this.sqlExecutor));
            }
        }
        metaData.init();
        SimpleDatabase database = new SimpleDatabase((RDBDatabaseMetaData)metaData, this.sqlExecutor);
        database.setAutoParse(true);
        SystemInitialize initialize = new SystemInitialize(this.sqlExecutor, (RDBDatabase)database, version);
        initialize.addScriptContext("db", jdbcUserName);
        initialize.addScriptContext("dbType", type.name());
        initialize.install();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof Service) {
            this.addGlobalVariable(beanName, bean);
        } else {
            ScriptScope scope = (ScriptScope)AnnotationUtils.findAnnotation((Class)ClassUtils.getUserClass((Object)bean), ScriptScope.class);
            if (scope != null) {
                this.addGlobalVariable(!scope.value().isEmpty() ? scope.value() : beanName, bean);
            }
        }
        return bean;
    }
}

