/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter;

import com.alibaba.fastjson.JSONException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.hswebframework.web.BusinessException;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.validate.SimpleValidateResults;
import org.hswebframework.web.validate.ValidateResults;
import org.hswebframework.web.validate.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.util.MimeType;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class RestControllerExceptionTranslator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={JSONException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    ResponseMessage handleException(JSONException exception) {
        this.logger.error(exception.getMessage(), (Throwable)exception);
        return ResponseMessage.error((int)400, (String)"\u89e3\u6790JSON\u5931\u8d25");
    }

    @ExceptionHandler(value={org.hswebframework.ezorm.rdb.exception.ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    ResponseMessage<Object> handleException(org.hswebframework.ezorm.rdb.exception.ValidationException exception) {
        return ResponseMessage.error((int)400, (String)exception.getMessage()).result(exception.getValidateResult());
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    ResponseMessage<List<ValidateResults.Result>> handleException(ValidationException exception) {
        return ResponseMessage.error((int)400, (String)exception.getMessage()).result((Object)exception.getResults());
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    ResponseMessage handleException(BusinessException exception) {
        if (exception.getCause() != null) {
            this.logger.error("{}:{}", new Object[]{exception.getMessage(), exception.getStatus(), exception.getCause()});
        }
        return ResponseMessage.error((int)exception.getStatus(), (String)exception.getMessage()).result((Object)exception.getCode());
    }

    @ExceptionHandler(value={UnAuthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    ResponseMessage handleException(UnAuthorizedException exception) {
        return ResponseMessage.error((int)401, (String)exception.getMessage()).result((Object)exception.getState());
    }

    @ExceptionHandler(value={AccessDenyException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    ResponseMessage handleException(AccessDenyException exception) {
        return ResponseMessage.error((int)403, (String)exception.getMessage());
    }

    @ExceptionHandler(value={NotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    ResponseMessage handleException(NotFoundException exception) {
        return ResponseMessage.error((int)404, (String)exception.getMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    ResponseMessage handleConstraintViolationException(ConstraintViolationException e) {
        SimpleValidateResults results = new SimpleValidateResults();
        for (ConstraintViolation violation : e.getConstraintViolations()) {
            results.addResult(violation.getPropertyPath().toString(), violation.getMessage());
        }
        List errorResults = results.getResults();
        return ResponseMessage.error((int)400, (String)(errorResults.isEmpty() ? "" : ((ValidateResults.Result)errorResults.get(0)).getMessage())).result((Object)errorResults);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    ResponseMessage handleException(BindException e) {
        SimpleValidateResults results = new SimpleValidateResults();
        e.getBindingResult().getAllErrors().stream().filter(FieldError.class::isInstance).map(FieldError.class::cast).forEach(fieldError -> results.addResult(fieldError.getField(), fieldError.getDefaultMessage()));
        return ResponseMessage.error((int)400, (String)(results.getResults().isEmpty() ? e.getMessage() : ((ValidateResults.Result)results.getResults().get(0)).getMessage())).result((Object)results.getResults());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    ResponseMessage handleException(MethodArgumentNotValidException e) {
        SimpleValidateResults results = new SimpleValidateResults();
        e.getBindingResult().getAllErrors().stream().filter(FieldError.class::isInstance).map(FieldError.class::cast).forEach(fieldError -> results.addResult(fieldError.getField(), fieldError.getDefaultMessage()));
        return ResponseMessage.error((int)400, (String)(results.getResults().isEmpty() ? e.getMessage() : ((ValidateResults.Result)results.getResults().get(0)).getMessage())).result((Object)results.getResults());
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    ResponseMessage handleException(RuntimeException exception) {
        String msg = Optional.ofNullable(exception.getMessage()).orElse("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        this.logger.error(exception.getMessage(), (Throwable)exception);
        return ResponseMessage.error((int)500, (String)msg);
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    ResponseMessage handleException(DuplicateKeyException exception) {
        this.logger.error(exception.getMessage(), (Throwable)exception);
        return ResponseMessage.error((int)400, (String)"\u91cd\u590d\u7684\u8bf7\u6c42");
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    ResponseMessage handleException(NullPointerException exception) {
        String msg = Optional.ofNullable(exception.getMessage()).orElse("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        this.logger.error(exception.getMessage(), (Throwable)exception);
        return ResponseMessage.error((int)500, (String)msg);
    }

    @ExceptionHandler(value={SQLException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    ResponseMessage handleException(SQLException exception) {
        this.logger.error(exception.getMessage(), (Throwable)exception);
        return ResponseMessage.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    ResponseMessage handleException(IllegalArgumentException exception) {
        String msg = exception.getMessage();
        if (null == msg) {
            msg = "\u53c2\u6570\u9519\u8bef";
            this.logger.error("\u53c2\u6570\u9519\u8bef", (Throwable)exception);
        }
        return ResponseMessage.error((int)400, (String)msg);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    ResponseMessage handleException(HttpRequestMethodNotSupportedException exception) {
        return ResponseMessage.error((int)HttpStatus.METHOD_NOT_ALLOWED.value(), (String)"\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f").result((Object)exception.getSupportedHttpMethods());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    ResponseMessage handleException(NoHandlerFoundException exception) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("url", exception.getRequestURL());
        result.put("method", exception.getHttpMethod());
        return ResponseMessage.error((int)HttpStatus.NOT_FOUND.value(), (String)"\u8bf7\u6c42\u5730\u5740\u4e0d\u5b58\u5728.");
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    ResponseMessage handleException(HttpMediaTypeNotSupportedException exception) {
        return ResponseMessage.error((int)HttpStatus.UNSUPPORTED_MEDIA_TYPE.value(), (String)("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u7c7b\u578b:" + exception.getContentType().toString())).result(exception.getSupportedMediaTypes().stream().map(MimeType::toString).collect(Collectors.toList()));
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    ResponseMessage handleException(MissingServletRequestParameterException exception) {
        return ResponseMessage.error((int)HttpStatus.BAD_REQUEST.value(), (String)("\u53c2\u6570[" + exception.getParameterName() + "]\u4e0d\u80fd\u4e3a\u7a7a"));
    }
}

