/*
 *
 *  * Copyright 2016 http://www.hswebframework.org
 *  *
 *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  * you may not use this file except in compliance with the License.
 *  * You may obtain a copy of the License at
 *  *
 *  *     http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the License for the specific language governing permissions and
 *  * limitations under the License.
 *
 */

package org.hswebframework.web.starter.init;

import org.hswebframework.web.starter.SystemVersion;

import java.util.Map;


/**
 * TODO 完成注释
 *
 * @author zhouhao
 */
public interface DependencyInstaller {
    DependencyInstaller setup(SystemVersion.Dependency dependency);

    default DependencyInstaller setup(Map<String, Object> mapDependency) {
        return setup(SystemVersion.Dependency.fromMap(mapDependency));
    }

    DependencyInstaller onInstall(InstallerCallBack callBack);

    DependencyInstaller onUpgrade(UpgradeCallBack callBack);

    DependencyInstaller onUninstall(InstallerCallBack callBack);

    DependencyInstaller onInitialize(InitializeCallBack initializeCallBack);
}
