/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter;

import org.hswebframework.utils.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Version
implements Comparable<Version> {
    private static final Logger log = LoggerFactory.getLogger(Version.class);
    protected String name;
    protected String comment;
    protected String website;
    protected int majorVersion = 1;
    protected int minorVersion = 0;
    protected int revisionVersion = 0;
    protected boolean snapshot = false;

    Version() {
    }

    public void setVersion(int major, int minor, int revision, boolean snapshot) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.revisionVersion = revision;
        this.snapshot = snapshot;
    }

    public void setVersion(String version) {
        if (null == version) {
            return;
        }
        version = version.toLowerCase();
        boolean snapshot = version.toLowerCase().contains("snapshot");
        String[] ver = version.split("[-]")[0].split("[.]");
        Integer[] numberVer = ListUtils.stringArr2intArr((String[])ver);
        if (numberVer.length == 0) {
            numberVer = new Integer[]{1, 0, 0};
            log.warn("\u89e3\u6790\u7248\u672c\u53f7\u5931\u8d25:{},\u5c06\u4f7f\u7528\u9ed8\u8ba4\u7248\u672c\u53f7:1.0.0,\u8bf7\u68c0\u67e5hsweb-starter.js\u914d\u7f6e\u5185\u5bb9!", (Object)version);
        }
        for (int i = 0; i < numberVer.length; ++i) {
            if (numberVer[i] != null) continue;
            numberVer[i] = 0;
        }
        this.setVersion(numberVer[0], numberVer.length <= 1 ? 0 : numberVer[1], numberVer.length <= 2 ? 0 : numberVer[2], snapshot);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getWebsite() {
        if (this.website == null) {
            this.website = "";
        }
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getRevisionVersion() {
        return this.revisionVersion;
    }

    public void setRevisionVersion(int revisionVersion) {
        this.revisionVersion = revisionVersion;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public int compareTo(Version o) {
        if (null == o) {
            return -1;
        }
        if (o.getMajorVersion() > this.getMajorVersion()) {
            return -1;
        }
        if (o.getMajorVersion() == this.getMajorVersion()) {
            if (o.getMinorVersion() > this.getMinorVersion()) {
                return -1;
            }
            if (o.getMinorVersion() == this.getMinorVersion()) {
                return Integer.compare(this.getRevisionVersion(), o.getRevisionVersion());
            }
            return 1;
        }
        return 1;
    }

    public String versionToString() {
        return String.valueOf(this.majorVersion) + "." + this.minorVersion + "." + this.revisionVersion + (this.snapshot ? "-SNAPSHOT" : "");
    }

    public String toString() {
        return this.name + " version " + this.majorVersion + "." + this.minorVersion + "." + this.revisionVersion + (this.snapshot ? "-SNAPSHOT" : "");
    }
}

