/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.starter.Version;

public class SystemVersion
extends Version {
    private FrameworkVersion frameworkVersion = new FrameworkVersion();
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private Map<String, Dependency> depCache;

    public SystemVersion() {
    }

    public SystemVersion(String version) {
        this.setVersion(version);
    }

    public FrameworkVersion getFrameworkVersion() {
        return this.frameworkVersion;
    }

    public void setFrameworkVersion(FrameworkVersion frameworkVersion) {
        this.frameworkVersion = frameworkVersion;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
        this.initDepCache();
    }

    protected String getDepKey(String groupId, String artifactId) {
        return StringUtils.concat((Object[])new Object[]{groupId, "/", artifactId});
    }

    protected void initDepCache() {
        this.depCache = new HashMap<String, Dependency>();
        this.dependencies.forEach(dependency -> this.depCache.put(this.getDepKey(dependency.groupId, dependency.artifactId), (Dependency)dependency));
    }

    public Dependency getDependency(String groupId, String artifactId) {
        if (this.depCache == null) {
            this.initDepCache();
        }
        return this.depCache.get(this.getDepKey(groupId, artifactId));
    }

    public static class Dependency
    extends Version {
        protected String groupId;
        protected String artifactId;
        protected String author;

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public static Dependency fromMap(Map<String, Object> map) {
            Dependency dependency = new Dependency();
            dependency.setGroupId((String)map.get("groupId"));
            dependency.setArtifactId((String)map.get("artifactId"));
            dependency.setName((String)map.getOrDefault("name", dependency.getArtifactId()));
            dependency.setVersion((String)map.get("version"));
            dependency.setWebsite((String)map.get("website"));
            dependency.setAuthor((String)map.get("author"));
            return dependency;
        }

        public boolean isSameDependency(Dependency dependency) {
            return this.isSameDependency(dependency.getGroupId(), dependency.getArtifactId());
        }

        public boolean isSameDependency(String groupId, String artifactId) {
            return groupId.equals(this.getGroupId()) && artifactId.equals(this.getArtifactId());
        }

        @Override
        public String toString() {
            return JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        }
    }

    public static interface Property {
        public static final String name = "name";
        public static final String comment = "comment";
        public static final String website = "website";
        public static final String majorVersion = "majorVersion";
        public static final String minorVersion = "minorVersion";
        public static final String revisionVersion = "revisionVersion";
        public static final String snapshot = "snapshot";
        public static final String frameworkVersion = "frameworkVersion";
        public static final String dependencies = "dependencies";
    }

    public static class FrameworkVersion
    extends Version {
        public FrameworkVersion() {
            this.setName("hsweb framework");
            this.setComment("\u4f01\u4e1a\u540e\u53f0\u7ba1\u7406\u7cfb\u7edf\u57fa\u7840\u6846\u67b6");
            this.setWebsite("http://www.hsweb.me");
            this.setComment("");
            this.setVersion(3, 0, 0, true);
        }
    }
}

