/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.convert;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.ThreadLocalUtils;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.convert.CustomMessageConverter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;

public class FastJsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object>
implements Ordered {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private Charset charset = UTF8;
    private SerializerFeature[] features = new SerializerFeature[0];
    private List<CustomMessageConverter> converters;

    public FastJsonHttpMessageConverter() {
        super(new MediaType[]{new MediaType("application", "json", UTF8), new MediaType("application", "*+json", UTF8)});
    }

    public void setConverters(List<CustomMessageConverter> converters) {
        this.converters = converters;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public SerializerFeature[] getFeatures() {
        return this.features;
    }

    public void setFeatures(SerializerFeature ... features) {
        this.features = features;
    }

    public Object readByString(Class<?> clazz, String jsonStr) {
        return this.readByBytes(clazz, jsonStr.getBytes());
    }

    public Object readByBytes(Class<?> clazz, byte[] bytes) {
        CustomMessageConverter converter;
        if (clazz == String.class) {
            return new String(bytes, this.charset);
        }
        if (null != this.converters && (converter = (CustomMessageConverter)this.converters.stream().filter(cvt -> cvt.support(clazz)).findFirst().orElse(null)) != null) {
            return converter.convert(clazz, bytes);
        }
        Object object = JSON.parseObject((byte[])bytes, (int)0, (int)bytes.length, (CharsetDecoder)this.charset.newDecoder(), clazz, (Feature[])new Feature[0]);
        return object;
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = inputMessage.getBody();
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            if (len <= 0) continue;
            baos.write(buf, 0, len);
        }
        byte[] bytes = baos.toByteArray();
        return this.readByBytes(clazz, bytes);
    }

    public String converter(Object obj) {
        String text;
        if (obj instanceof String) {
            return (String)obj;
        }
        String callback = (String)ThreadLocalUtils.getAndRemove((String)"jsonp-callback");
        if (obj instanceof ResponseMessage) {
            ResponseMessage message = (ResponseMessage)obj;
            text = JSON.toJSONString((Object)obj, (SerializeFilter[])FastJsonHttpMessageConverter.parseFilter(message), (SerializerFeature[])this.features);
        } else {
            text = JSON.toJSONString((Object)obj, (SerializerFeature[])this.features);
        }
        if (!StringUtils.isNullOrEmpty((Object)callback)) {
            text = callback + "(" + text + ")";
        }
        return text;
    }

    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException {
        OutputStream out = outputMessage.getBody();
        byte[] bytes = this.converter(obj).getBytes(this.charset);
        out.write(bytes);
        out.flush();
    }

    public static SerializeFilter[] parseFilter(ResponseMessage<?> responseMessage) {
        SimplePropertyPreFilter filter;
        ArrayList<Object> filters = new ArrayList<Object>();
        if (responseMessage.getIncludes() != null) {
            for (Map.Entry classSetEntry : responseMessage.getIncludes().entrySet()) {
                filter = new SimplePropertyPreFilter((Class)classSetEntry.getKey(), new String[0]);
                filter.getIncludes().addAll((Collection)classSetEntry.getValue());
                filters.add(filter);
            }
        }
        if (responseMessage.getExcludes() != null) {
            for (Map.Entry classSetEntry : responseMessage.getExcludes().entrySet()) {
                filter = new SimplePropertyPreFilter((Class)classSetEntry.getKey(), new String[0]);
                filter.getExcludes().addAll((Collection)classSetEntry.getValue());
                filters.add(filter);
            }
        }
        PropertyFilter responseMessageFilter = (object, name, value) -> !(object instanceof ResponseMessage) || value != null;
        filters.add(responseMessageFilter);
        return filters.toArray(new SerializeFilter[filters.size()]);
    }
}

