/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter;

import java.util.Collections;
import java.util.Optional;
import org.hswebframework.web.starter.CorsProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@ConditionalOnProperty(prefix="hsweb.cors", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={CorsProperties.class})
public class CorsAutoConfiguration {
    private static final String CORS_PATH_ALL = "/**";

    @Bean
    public CorsFilter corsFilter(CorsProperties corsProperties) {
        UrlBasedCorsConfigurationSource corsConfigurationSource = new UrlBasedCorsConfigurationSource();
        Optional.ofNullable(corsProperties.getConfigs()).orElse(Collections.singletonList(Collections.singletonMap(CORS_PATH_ALL, new CorsProperties.CorsConfiguration().applyPermitDefaultValues()))).forEach(map -> map.forEach((path, config) -> corsConfigurationSource.registerCorsConfiguration(path, this.buildConfiguration((CorsProperties.CorsConfiguration)config))));
        return new CorsFilter((CorsConfigurationSource)corsConfigurationSource);
    }

    private CorsConfiguration buildConfiguration(CorsProperties.CorsConfiguration config) {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowedHeaders(config.getAllowedHeaders());
        corsConfiguration.setAllowedMethods(config.getAllowedMethods());
        corsConfiguration.setAllowedOrigins(config.getAllowedOrigins());
        corsConfiguration.setAllowCredentials(config.getAllowCredentials());
        corsConfiguration.setExposedHeaders(config.getExposedHeaders());
        corsConfiguration.setMaxAge(config.getMaxAge());
        return corsConfiguration;
    }
}

